"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.deviceSchedulePowerAction = void 0;
const socketActionCreator_1 = require("../../../Socket/socketActionCreator");
const devicePowerActions_1 = require("@signageos/actions/dist/Device/Power/devicePowerActions");
const PowerActionType_1 = __importDefault(require("@signageos/actions/dist/Device/Power/PowerActionType"));
const deviceSchedulePowerActionSagas_1 = require("../../../Device/Power/deviceSchedulePowerActionSagas");
const powerActionTimers_1 = require("./powerActionTimers");
const FrontPowerActionExecutor_1 = __importDefault(require("./FrontPowerActionExecutor"));
function* deviceSchedulePowerAction(propertyStorage) {
    yield (0, socketActionCreator_1.bindWhenPlatform)([devicePowerActions_1.SchedulePowerAction, devicePowerActions_1.CancelScheduledPowerAction]);
    const powerActionExecutor = new FrontPowerActionExecutor_1.default();
    const powerActionTimer = (0, powerActionTimers_1.createFrontPowerActionTimer)(propertyStorage, powerActionExecutor);
    yield powerActionExecutor.takeEveryAction();
    yield (0, deviceSchedulePowerActionSagas_1.deviceSchedulePowerActionCommon)(powerActionTimer, (powerType) => {
        return (powerType === PowerActionType_1.default.APPLET_REFRESH ||
            powerType === PowerActionType_1.default.APPLET_RELOAD ||
            powerType === PowerActionType_1.default.APPLET_ENABLE ||
            powerType === PowerActionType_1.default.APPLET_DISABLE);
    });
}
exports.deviceSchedulePowerAction = deviceSchedulePowerAction;
//# sourceMappingURL=deviceSchedulePowerActionSagas.js.map