"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const effects_1 = require("redux-saga/effects");
const devicePowerActionActions_1 = require("./devicePowerActionActions");
const redux_saga_1 = require("redux-saga");
class FrontPowerActionExecutor {
    constructor() {
        this.channel = (0, redux_saga_1.channel)(redux_saga_1.buffers.none());
    }
    execute(powerAction) {
        this.channel.put(powerAction);
    }
    takeEveryAction() {
        return (0, effects_1.takeEvery)(this.channel, function* (powerType) {
            yield (0, effects_1.put)({
                type: devicePowerActionActions_1.PerformScheduledPowerAction,
                powerType,
            });
        });
    }
}
exports.default = FrontPowerActionExecutor;
//# sourceMappingURL=FrontPowerActionExecutor.js.map