"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.deviceDeprovision = void 0;
const deviceDeprovisionActions_1 = require("@signageos/actions/dist/Device/Deprovision/deviceDeprovisionActions");
const Responsibility_1 = __importDefault(require("../../../Feature/Responsibility"));
const socketActionCreator_1 = require("../../../Socket/socketActionCreator");
function* deviceDeprovision(getNativeDriver, getManagementDriver, responsibilities, sessionIdKey) {
    if (responsibilities.has(Responsibility_1.default.DEPROVISIONING)) {
        yield (0, socketActionCreator_1.takeEveryAndBindWhenPlatform)(deviceDeprovisionActions_1.PerformDeviceDeprovision, function* () {
            try {
                yield Promise.allSettled([
                    getNativeDriver().security.setPin(''),
                    getNativeDriver().remoteControlSetEnabled(true),
                    getNativeDriver().hardware.led.setColor('#00000'),
                    getManagementDriver().wifi.disconnect(),
                    getManagementDriver().wifi.disable(),
                    getNativeDriver().setSessionId(sessionIdKey, ''),
                ]);
            }
            catch (error) {
                console.error('deviceDeprovision failed', error);
            }
        });
    }
}
exports.deviceDeprovision = deviceDeprovision;
//# sourceMappingURL=deviceDeprovisionSagas.js.map