"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.readSetDeviceDebugSettingsCallback = exports.readSetDeviceDebugSettings = exports.setDeviceDebugSettingsCallback = exports.devicePerformDebugSettings = void 0;
const socketActionCreator_1 = require("../../../Socket/socketActionCreator");
const effects_1 = require("redux-saga/effects");
const deviceDebugActions_1 = require("@signageos/actions/dist/Device/Debug/deviceDebugActions");
const deviceDebugLocalActions_1 = require("./deviceDebugLocalActions");
const deviceDebugHelper_1 = require("./deviceDebugHelper");
const Property_1 = __importDefault(require("../../../Property/Property"));
const applicationActions_1 = require("@signageos/actions/dist/Application/applicationActions");
const activeAppletActions_1 = require("@signageos/actions/dist/Applet/activeAppletActions");
const sendAppletMessage_1 = require("../../Applet/sendAppletMessage");
function* devicePerformDebugSettings(global, getNativeDriver, propertyStorage, messageTypePrefix, getState) {
    yield (0, socketActionCreator_1.takeEveryAndBindWhenPlatform)(deviceDebugActions_1.SetDeviceDebugSettings, setDeviceDebugSettingsCallback, global, getNativeDriver, propertyStorage, messageTypePrefix, getState);
}
exports.devicePerformDebugSettings = devicePerformDebugSettings;
function* setDeviceDebugSettingsCallback(global, getNativeDriver, propertyStorage, messageTypePrefix, getState, { weinreEnabled, appletEnabled, uid }) {
    try {
        // Back compatibility with old platform (appletEnabled was weinreEnabled in past)
        weinreEnabled = typeof weinreEnabled === 'undefined' ? !!appletEnabled : !!weinreEnabled;
        yield propertyStorage.setValue(Property_1.default.DEBUG_WEINRE_ENABLED, weinreEnabled);
        if (weinreEnabled) {
            (0, deviceDebugHelper_1.startWeinreDebug)(global);
        }
        yield* setDebugInAppletIfSomeActive(global, getNativeDriver, propertyStorage, messageTypePrefix, getState, () => weinreEnabled);
        yield (0, effects_1.put)({
            type: deviceDebugActions_1.SetDeviceDebugSettingsSucceeded,
            uid,
        });
    }
    catch (e) {
        yield (0, effects_1.put)({
            type: deviceDebugActions_1.SetDeviceDebugSettingsFailed,
            uid,
        });
    }
}
exports.setDeviceDebugSettingsCallback = setDeviceDebugSettingsCallback;
function* readSetDeviceDebugSettings(global, getNativeDriver, propertyStorage, messageTypePrefix, getState) {
    yield (0, effects_1.takeEvery)(applicationActions_1.StartApplication, readSetDeviceDebugSettingsCallback, propertyStorage);
    yield (0, effects_1.takeEvery)(activeAppletActions_1.ActiveAppletReady, setDebugInAppletIfSomeActive, global, getNativeDriver, propertyStorage, messageTypePrefix, getState, () => getState().debug.debugOn);
}
exports.readSetDeviceDebugSettings = readSetDeviceDebugSettings;
function* readSetDeviceDebugSettingsCallback(propertyStorage) {
    const debugOnFromStorage = yield propertyStorage.getValueOrDefault(Property_1.default.DEBUG_WEINRE_ENABLED, false);
    yield (0, effects_1.put)({
        type: deviceDebugLocalActions_1.ReadDeviceDebugSettings,
        debugOn: debugOnFromStorage,
    });
}
exports.readSetDeviceDebugSettingsCallback = readSetDeviceDebugSettingsCallback;
function* setDebugInAppletIfSomeActive(global, getNativeDriver, propertyStorage, messageTypePrefix, getState, isEnabled) {
    const url = yield propertyStorage.getValueOrDefault(Property_1.default.DEBUG_WEINRE_SERVER_URL, '');
    const duid = yield getNativeDriver().getDeviceUid();
    const activeAppletUid = getState().applet.activeAppletUid;
    if (activeAppletUid) {
        yield (0, sendAppletMessage_1.sendMessageToActiveAppletIfExists)(global, getState, {
            type: messageTypePrefix + '.debug.configure',
            enabled: isEnabled(),
            url,
            id: `${duid}_${activeAppletUid}`,
        });
    }
}
//# sourceMappingURL=deviceDebugSettingsSagas.js.map