"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.application = void 0;
const applicationActions_1 = require("@signageos/actions/dist/Application/applicationActions");
const deviceConfigurationActions_1 = require("../../Device/Configuration/deviceConfigurationActions");
const IConfig_1 = require("../../Display/IConfig");
const initialState = {
    started: false,
    baseUrl: null,
    subscriptionType: null,
};
function application(state = initialState, action) {
    switch (action.type) {
        case applicationActions_1.StartApplication:
            return Object.assign(Object.assign({}, state), { started: true });
        case applicationActions_1.UpdateBaseUrl:
            return Object.assign(Object.assign({}, state), { baseUrl: action.baseUrl });
        case deviceConfigurationActions_1.ChangeSubscriptionToOpen:
            return Object.assign(Object.assign({}, state), { subscriptionType: IConfig_1.SubscriptionType.open });
        case deviceConfigurationActions_1.ChangeSubscriptionToPlatform:
            return Object.assign(Object.assign({}, state), { subscriptionType: IConfig_1.SubscriptionType.platform });
        default:
            return state;
    }
}
exports.application = application;
//# sourceMappingURL=applicationReducers.js.map