import { StartApplication, UpdateBaseUrl } from '@signageos/actions/dist/Application/applicationActions';
import { ChangeSubscriptionToOpen, ChangeSubscriptionToPlatform } from '../../Device/Configuration/deviceConfigurationActions';
import { SubscriptionType } from '../../Display/IConfig';
export interface IApplicationState {
    started: boolean;
    baseUrl: string | null;
    /**
     * null means never determined by server.
     * It could be even platform but first-time the server is connected, the subscriptionType is stored to storage.
     * On every start, the stored subscriptionType is used.
     */
    subscriptionType: SubscriptionType | null;
}
export declare function application(state: IApplicationState | undefined, action: UpdateBaseUrl | StartApplication | ChangeSubscriptionToOpen | ChangeSubscriptionToPlatform): IApplicationState;
