import { IAppletTimingDefinition, UpdateActiveAppletBinary } from '@signageos/actions/dist/Applet/appletActions';
import { IWebWorkerFactory } from '../../WebWorker/masterWebWorkerFactory';
import { PrepareNextAppletTiming } from './appletTimingActions';
/**
 * This saga controls the flow of when to run which applet
 *
 * It starts with no definitions and in that case, there are no applets to run so it does nothing.
 *
 * Once it receives action UpdateAppletTimingsDefinition with new timing definitions, it stores the definitions
 * and starts processing them from the beginning.
 *
 * The heart of this process is an infinite loop that iterates over the definitions list and triggers switch to the next applet
 * when conditions are met. However, this loop is not part of this file. Since it's an infinite loop whose only job is to do some
 * simple decision making, it made sense to run it in a separate service worker - i.e. another thread.
 * This infinite loop can be found in src/Front/AppletTiming/AppletTimingController.ts.
 */
export declare function controlActiveAppletTiming(webWorkerFactory: IWebWorkerFactory, defaultDefinitions?: IAppletTimingDefinition[]): Generator<import("redux-saga/effects").ForkEffect<any> | Generator<import("redux-saga/effects").ForkEffect<never>, void, unknown>, void, unknown>;
export interface ILoopModel {
    definitions: IAppletTimingDefinition[] | null;
    currentDefinitionIndex: number | null;
    startTimestamp: number | null;
    lastInteractionTimestamp: number | null;
    triggersPausedTimestamp: number | null;
    lastPutUpdateActiveAppletBinary: UpdateActiveAppletBinary | null;
    lastPutPrepareNextAppletTiming: PrepareNextAppletTiming | null;
    deviceInConnectedMode: null | {
        connected: boolean;
        appletUid: string;
        appletVersion: string;
    };
}
