"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.saveAppletBinary = exports.deleteTimingsDefinitionCallback = exports.deleteAppletTimingsDefinition = exports.saveAppletTimingsDefinition = exports.loadAppletTimingsDefinition = void 0;
const socketActionCreator_1 = require("../../Socket/socketActionCreator");
const effects_1 = require("redux-saga/effects");
const applicationActions_1 = require("@signageos/actions/dist/Application/applicationActions");
const appletActions_1 = require("@signageos/actions/dist/Applet/appletActions");
const TimingFinishEventType_1 = __importDefault(require("./TimingFinishEventType"));
const Property_1 = __importDefault(require("../../Property/Property"));
const activeAppletActions_1 = require("../Applet/activeAppletActions");
function* loadAppletTimingsDefinition(propertyStorage) {
    yield (0, effects_1.takeEvery)(applicationActions_1.StartApplication, function* () {
        try {
            const updateAppletTimingsDefinition = yield propertyStorage.getValueOrDefault(Property_1.default.APPLET_TIMINGS_UPDATE_DEFINITION, null);
            if (updateAppletTimingsDefinition) {
                yield (0, effects_1.put)(updateAppletTimingsDefinition);
            }
        }
        catch (error) {
            console.error('loadAppletTimingsDefinition failed', error);
        }
    });
}
exports.loadAppletTimingsDefinition = loadAppletTimingsDefinition;
function* saveAppletTimingsDefinition(propertyStorage) {
    yield (0, socketActionCreator_1.bindAndTakeEveryOnlyWhenPlatform)(appletActions_1.UpdateAppletTimingsDefinition, function* (action) {
        try {
            yield propertyStorage.setValue(Property_1.default.APPLET_TIMINGS_UPDATE_DEFINITION, action);
        }
        catch (error) {
            console.error('saveAppletTimingsDefinition failed', error);
        }
    });
}
exports.saveAppletTimingsDefinition = saveAppletTimingsDefinition;
function* deleteAppletTimingsDefinition(propertyStorage, defaultDefinitions) {
    const defaultDefinitionsOrNull = () => {
        if (defaultDefinitions && defaultDefinitions.length > 0) {
            return defaultDefinitions;
        }
        return null;
    };
    const definitions = defaultDefinitionsOrNull();
    yield (0, socketActionCreator_1.bindAndTakeEvery)(appletActions_1.LastActiveAppletMissed, deleteTimingsDefinitionCallback, propertyStorage, definitions);
}
exports.deleteAppletTimingsDefinition = deleteAppletTimingsDefinition;
function* deleteTimingsDefinitionCallback(propertyStorage, timingDefinitions) {
    yield propertyStorage.removeValue(Property_1.default.APPLET_TIMINGS_UPDATE_DEFINITION);
    if (!timingDefinitions) {
        yield (0, effects_1.put)({
            type: appletActions_1.UpdateActiveAppletBinaryFile,
            appletBinaryFile: null,
            appletFrontAppletJsFile: null,
        });
        yield (0, effects_1.put)({ type: activeAppletActions_1.ActiveAppletRestore });
    }
}
exports.deleteTimingsDefinitionCallback = deleteTimingsDefinitionCallback;
function* saveAppletBinary() {
    yield (0, socketActionCreator_1.bindAndTakeEveryOnlyWhenPlatform)(appletActions_1.UpdateActiveAppletBinary, function* (action) {
        try {
            // only UPDATE_ACTIVE_APPLET_BINARY dispatched from are stored as definition for BC
            if (typeof action.__source !== 'undefined') {
                yield (0, effects_1.put)({
                    type: appletActions_1.UpdateAppletTimingsDefinition,
                    definitions: [
                        {
                            appletUid: action.activeAppletUid,
                            configuration: action.activeConfiguration,
                            timmingChecksum: action.activeTimingChecksum,
                            appletVersion: action.activeAppletVersion,
                            appletVersionPostfix: action.activeAppletVersionPostfix,
                            isPackage: action.activeAppletIsPackage,
                            frontAppletVersion: action.activeAppletFrontAppletVersion || action.activeAppletHugApiVersion, // deprecated will be deleted
                            finishEvent: {
                                type: TimingFinishEventType_1.default[TimingFinishEventType_1.default.DURATION],
                                data: null,
                            },
                            position: 1,
                            metadata: action.activeAppletMetadata,
                        },
                    ],
                });
            }
        }
        catch (error) {
            console.error('saveAppletBinary failed', error);
        }
    });
}
exports.saveAppletBinary = saveAppletBinary;
//# sourceMappingURL=appletTimingCacheSagas.js.map