"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDefaultAppletTimingDefinition = void 0;
const TimingFinishEventType_1 = __importDefault(require("../AppletTiming/TimingFinishEventType"));
function getDefaultAppletTimingDefinition(appletUid, appletVersion, frontAppletVersion, checksum, config) {
    const DEFAULT_FINISH_EVENT = {
        type: TimingFinishEventType_1.default[TimingFinishEventType_1.default.DURATION],
        data: null,
    };
    return {
        appletUid,
        configuration: config !== null && config !== void 0 ? config : {},
        timmingChecksum: checksum,
        appletVersion,
        frontAppletVersion,
        finishEvent: DEFAULT_FINISH_EVENT,
        position: 1,
    };
}
exports.getDefaultAppletTimingDefinition = getDefaultAppletTimingDefinition;
//# sourceMappingURL=defaultApplet.js.map