"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.handleAppletMessage = exports.handleAppletManagementMessage = void 0;
const appletBrowserHandler_1 = __importDefault(require("./Browser/appletBrowserHandler"));
const appletCommandHandler_1 = __importDefault(require("./Command/appletCommandHandler"));
const appletDeviceInfoHandler_1 = __importDefault(require("./DeviceInfo/appletDeviceInfoHandler"));
const appletDisplayHandler_1 = __importDefault(require("./Display/appletDisplayHandler"));
const appletFileSystemHandler_1 = __importDefault(require("./FileSystem/appletFileSystemHandler"));
const appletHardwareBarcodeScannerHandler_1 = __importDefault(require("./Hardware/appletHardwareBarcodeScannerHandler"));
const appletHardwareHandler_1 = __importDefault(require("./Hardware/appletHardwareHandler"));
const appletHardwareSerialPortHandler_1 = __importDefault(require("./Hardware/appletHardwareSerialPortHandler"));
const pingHandler_1 = __importDefault(require("./Main/pingHandler"));
const refreshHandler_1 = __importDefault(require("./Main/refreshHandler"));
const appletManagementNetworkHandler_1 = __importDefault(require("./Management/Network/appletManagementNetworkHandler"));
const appletManagementProxyHandler_1 = __importDefault(require("./Management/Proxy/appletManagementProxyHandler"));
const appletManagementSystemInfoHandler_1 = __importDefault(require("./Management/SystemInfo/appletManagementSystemInfoHandler"));
const appletWifiHandler_1 = __importDefault(require("./Management/Wifi/appletWifiHandler"));
const appletManagementHandler_1 = __importDefault(require("./Management/appletManagementHandler"));
const appletMonitorsHandler_1 = __importDefault(require("./Monitors/appletMonitorsHandler"));
const nativeCommandHandler_1 = __importDefault(require("./Native/nativeCommandHandler"));
const appletOSDHandler_1 = __importDefault(require("./OSD/appletOSDHandler"));
const appletOfflineCacheHandler_1 = __importDefault(require("./OfflineCache/appletOfflineCacheHandler"));
const appletStreamHandler_1 = __importDefault(require("./Stream/appletStreamHandler"));
const appletSyncHandler_1 = __importDefault(require("./Sync/appletSyncHandler"));
const appletTimingHandler_1 = __importDefault(require("./Timing/appletTimingHandler"));
const appletTouchHandler_1 = __importDefault(require("./Touch/appletTouchHandler"));
const appletVideoHandler_1 = __importDefault(require("./Video/appletVideoHandler"));
const appletSecretsHandler_1 = __importDefault(require("./Secrets/appletSecretsHandler"));
const managementHandlers = [
    appletWifiHandler_1.default,
    appletManagementHandler_1.default,
    appletManagementNetworkHandler_1.default,
    appletMonitorsHandler_1.default,
    appletManagementProxyHandler_1.default,
    appletManagementSystemInfoHandler_1.default,
    nativeCommandHandler_1.default,
    appletSecretsHandler_1.default,
];
const frontHandlers = [
    refreshHandler_1.default,
    pingHandler_1.default,
    appletVideoHandler_1.default,
    appletStreamHandler_1.default,
    appletCommandHandler_1.default,
    appletHardwareHandler_1.default,
    appletHardwareBarcodeScannerHandler_1.default,
    appletHardwareSerialPortHandler_1.default,
    appletTouchHandler_1.default,
    appletOfflineCacheHandler_1.default,
    appletBrowserHandler_1.default,
    appletTimingHandler_1.default,
    appletSyncHandler_1.default,
    appletFileSystemHandler_1.default,
    appletDisplayHandler_1.default,
    appletDeviceInfoHandler_1.default,
    appletOSDHandler_1.default,
];
function* handleAppletManagementMessage(parameters) {
    return yield handleAppletMessageWithHandlers(parameters, managementHandlers);
}
exports.handleAppletManagementMessage = handleAppletManagementMessage;
function* handleAppletMessage(parameters) {
    const handlers = [...managementHandlers, ...frontHandlers];
    return yield handleAppletMessageWithHandlers(parameters, handlers);
}
exports.handleAppletMessage = handleAppletMessage;
function* handleAppletMessageWithHandlers(parameters, handlers) {
    for (let index = 0; index < handlers.length; index++) {
        const handler = handlers[index];
        const response = yield handler(parameters);
        if (response !== null) {
            return response;
        }
    }
    const { messageTypePrefix, data } = parameters;
    const overlookedMessages = [messageTypePrefix + '_loader.ready', messageTypePrefix + '_api.ready'];
    if (overlookedMessages.indexOf(data.type) === -1) {
        throw new Error('Unknown message type: ' + data.type);
    }
    return {};
}
//# sourceMappingURL=appletMessageHandler.js.map