"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.videoEventEmitting = exports.restoreOnAppletChange = exports.activeAppletRestore = void 0;
const effects_1 = require("redux-saga/effects");
const EmitVideoEvent_1 = require("./EmitVideoEvent");
const sendAppletMessage_1 = require("../sendAppletMessage");
const activeAppletActions_1 = require("../activeAppletActions");
const appletTimingActions_1 = require("../../AppletTiming/appletTimingActions");
function* activeAppletRestore(getNativeDriver, getSynchronizer) {
    yield (0, effects_1.takeEvery)(activeAppletActions_1.ActiveAppletRestore, function* () {
        try {
            yield getNativeDriver().restoreDisplayArea();
        }
        catch (error) {
            console.error('activeAppletRestore restoreDisplayArea failed', error);
        }
        try {
            const synchronizer = getSynchronizer();
            const isConnected = yield synchronizer.isConnected();
            if (isConnected) {
                yield synchronizer.close();
            }
        }
        catch (error) {
            console.error('activeAppletRestore synchronizer close failed', error);
        }
    });
}
exports.activeAppletRestore = activeAppletRestore;
function* restoreOnAppletChange() {
    yield (0, effects_1.takeEvery)(appletTimingActions_1.StartAppletIframe, function* () {
        try {
            yield (0, effects_1.put)({ type: activeAppletActions_1.ActiveAppletRestore });
        }
        catch (error) {
            console.error('restoreOnAppletChange failed', error);
        }
    });
}
exports.restoreOnAppletChange = restoreOnAppletChange;
function* videoEventEmitting(window, messageTypePrefix, getState) {
    yield (0, effects_1.takeEvery)(EmitVideoEvent_1.EmitVideoEvent, function* (action) {
        const event = action.event;
        yield (0, sendAppletMessage_1.sendMessageToActiveAppletIfExists)(window, getState, {
            type: messageTypePrefix + '.video.' + event.type,
            uri: event.srcArguments.uri,
            x: event.srcArguments.x,
            y: event.srcArguments.y,
            width: event.srcArguments.width,
            height: event.srcArguments.height,
        });
    });
}
exports.videoEventEmitting = videoEventEmitting;
//# sourceMappingURL=appletVideoSagas.js.map