"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handleAppletTimingMessage = void 0;
const effects_1 = require("redux-saga/effects");
const appletTimingActions_1 = require("../../AppletTiming/appletTimingActions");
function* handleAppletTimingMessage(messageTypePrefix, data) {
    switch (data.type) {
        case messageTypePrefix + '.timing.triggers.pause':
            yield (0, effects_1.put)({
                type: appletTimingActions_1.PauseAppletTimingTriggers,
            });
            return {};
        case messageTypePrefix + '.timing.triggers.resume':
            yield (0, effects_1.put)({
                type: appletTimingActions_1.ResumeAppletTimingTriggers,
            });
            return {};
        default:
            return null;
    }
}
exports.handleAppletTimingMessage = handleAppletTimingMessage;
function* timingHandler({ messageTypePrefix, data }) {
    return yield handleAppletTimingMessage(messageTypePrefix, data);
}
exports.default = timingHandler;
//# sourceMappingURL=appletTimingHandler.js.map