"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.syncEventEmitting = exports.ClosedAction = exports.BroadcastedValueAction = exports.GroupStatusAction = void 0;
const debug_1 = __importDefault(require("debug"));
const effects_1 = require("redux-saga/effects");
const channels_1 = require("../../../ReduxSaga/channels");
const sendAppletMessage_1 = require("../sendAppletMessage");
const ISynchronizer_1 = require("../../../Synchronization/ISynchronizer");
const debug = (0, debug_1.default)('@signageos/front-display:Applet:Sync:appletSyncSagas');
exports.GroupStatusAction = 'Sync.GroupStatus';
exports.BroadcastedValueAction = 'Sync.BroadcastedValue';
exports.ClosedAction = 'Sync.Closed';
function* syncEventEmitting(window, messageTypePrefix, getState, synchronizer) {
    const syncValueChannel = (0, channels_1.createChannel)((putEvent) => {
        synchronizer.addListener(ISynchronizer_1.SynchronizerEvent.GroupStatus, (event) => {
            debug('got group status event', event);
            const action = Object.assign({ type: exports.GroupStatusAction }, event);
            putEvent(action);
        });
        synchronizer.addListener(ISynchronizer_1.SynchronizerEvent.BroadcastedValue, (event) => {
            debug('got broadcasted value event', event);
            const action = Object.assign({ type: exports.BroadcastedValueAction }, event);
            putEvent(action);
        });
        synchronizer.addListener(ISynchronizer_1.SynchronizerEvent.Closed, (error) => {
            var _a;
            debug('got closed event', error);
            const action = {
                type: exports.ClosedAction,
                error: (_a = error === null || error === void 0 ? void 0 : error.message) !== null && _a !== void 0 ? _a : undefined,
            };
            putEvent(action);
        });
    });
    // spawn process that will take sync events and create messages for applet from them
    yield (0, effects_1.spawn)(channels_1.takeEvery, syncValueChannel, function* (action) {
        try {
            switch (action.type) {
                case exports.GroupStatusAction:
                    debug('sending group status event to applet', action);
                    yield (0, sendAppletMessage_1.sendMessageToActiveAppletIfExists)(window, getState, {
                        type: messageTypePrefix + '.sync.device_status',
                        connectedPeers: action.connectedPeers,
                        groupName: action.groupName,
                        isMaster: action.isMaster,
                    });
                    break;
                case exports.BroadcastedValueAction:
                    debug('sending broadcasted value event to applet', action);
                    yield (0, sendAppletMessage_1.sendMessageToActiveAppletIfExists)(window, getState, {
                        type: messageTypePrefix + '.sync.set_value',
                        groupName: action.groupName,
                        key: action.key,
                        value: action.value,
                    });
                    break;
                case exports.ClosedAction:
                    debug('sending closed event to applet', action);
                    yield (0, sendAppletMessage_1.sendMessageToActiveAppletIfExists)(window, getState, {
                        type: messageTypePrefix + '.sync.closed',
                        error: action.error,
                    });
                    break;
                default:
            }
        }
        catch (error) {
            console.error('sync set value event sending failed', error);
        }
    });
}
exports.syncEventEmitting = syncEventEmitting;
//# sourceMappingURL=appletSyncSagas.js.map