"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.appletSyncEngineToSynchronizerSynchronizerType = void 0;
const IPolymorphicSynchronizer_1 = require("../../../Synchronization/PolymorphicSynchronizer/IPolymorphicSynchronizer");
const ISyncConnectMessage_1 = require("./ISyncConnectMessage");
function appletSyncEngineToSynchronizerSynchronizerType(engine) {
    if (engine === undefined) {
        return undefined;
    }
    switch (engine) {
        case ISyncConnectMessage_1.SyncEngine.SyncServer:
            return IPolymorphicSynchronizer_1.SynchronizerType.SyncServer;
        // keep Udp for backwards compatibility, it's the same as P2PLocal
        case ISyncConnectMessage_1.SyncEngine.Udp:
        case ISyncConnectMessage_1.SyncEngine.P2PLocal:
            return IPolymorphicSynchronizer_1.SynchronizerType.P2PLocal;
        default:
            throw new Error('Unknown sync engine: ' + engine);
    }
}
exports.appletSyncEngineToSynchronizerSynchronizerType = appletSyncEngineToSynchronizerSynchronizerType;
//# sourceMappingURL=appletSyncHandler.utils.js.map