"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.streamEventEmitting = void 0;
const effects_1 = require("redux-saga/effects");
const sendAppletMessage_1 = require("../sendAppletMessage");
const streamActions_1 = require("../../../Stream/streamActions");
function* streamEventEmitting(window, messageTypePrefix, getState) {
    yield (0, effects_1.takeEvery)(streamActions_1.StreamError, function* (action) {
        yield (0, sendAppletMessage_1.sendMessageToActiveAppletIfExists)(window, getState, Object.assign(Object.assign({}, createMessage(messageTypePrefix, 'stream.error', action)), { protocol: action.protocol, errorMessage: action.errorMessage }));
    });
    yield (0, effects_1.takeEvery)(streamActions_1.StreamConnected, function* (action) {
        yield (0, sendAppletMessage_1.sendMessageToActiveAppletIfExists)(window, getState, Object.assign(Object.assign({}, createMessage(messageTypePrefix, 'stream.connected', action)), { protocol: action.protocol }));
    });
    yield (0, effects_1.takeEvery)(streamActions_1.StreamDisconnected, function* (action) {
        yield (0, sendAppletMessage_1.sendMessageToActiveAppletIfExists)(window, getState, Object.assign(Object.assign({}, createMessage(messageTypePrefix, 'stream.disconnected', action)), { protocol: action.protocol }));
    });
    yield (0, effects_1.takeEvery)(streamActions_1.StreamTracksChanged, function* (action) {
        yield (0, sendAppletMessage_1.sendMessageToActiveAppletIfExists)(window, getState, Object.assign(Object.assign({}, createMessage(messageTypePrefix, 'stream.tracks_changed', action)), { tracks: action.tracks }));
    });
}
exports.streamEventEmitting = streamEventEmitting;
function createMessage(messageTypePrefix, type, action) {
    return {
        type: messageTypePrefix + '.' + type,
        uri: action.uri,
        x: action.x,
        y: action.y,
        width: action.width,
        height: action.height,
    };
}
//# sourceMappingURL=appletStreamSagas.js.map