"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.handleSecretsMessage = void 0;
const DecryptMessage = 'hug.secrets.decryptSecret';
function* handleSecretsMessage(messageTypePrefix, data, managementDriver) {
    switch (data.type) {
        case messageTypePrefix + '.secret_decrypt':
            return yield handleDecryptValue(data.value, managementDriver);
        default:
            return null;
    }
}
exports.handleSecretsMessage = handleSecretsMessage;
function* secretsHandler({ messageTypePrefix, data, managementDriver }) {
    return yield handleSecretsMessage(messageTypePrefix, data, managementDriver);
}
exports.default = secretsHandler;
function handleDecryptValue(value, managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const decrypted = yield managementDriver.secretManager.decryptJweGeneralToUtf8(JSON.parse(value));
        return {
            decryptedValue: decrypted,
        };
    });
}
//# sourceMappingURL=appletSecretsHandler.js.map