"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handleOSDMessage = void 0;
const osdSagas_1 = require("../../Input/osdSagas");
const OSDMessage = 'hug.osd.show_osd';
const OSD_OPEN_WAIT_TIME = 6e3;
function* handleOSDMessage(messageTypePrefix, data, frontDriver, state) {
    switch (data.type) {
        case messageTypePrefix + '.osd.show_osd':
            return yield (0, osdSagas_1.putOpenOSD)(frontDriver, state, OSD_OPEN_WAIT_TIME);
        default:
            return null;
    }
}
exports.handleOSDMessage = handleOSDMessage;
function* osdHandler({ messageTypePrefix, data, frontDriver, getState }) {
    const state = getState();
    return yield handleOSDMessage(messageTypePrefix, data, frontDriver, state);
}
exports.default = osdHandler;
//# sourceMappingURL=appletOSDHandler.js.map