"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.handleNativeCommandMessage = void 0;
const ManagementCapabilities_1 = require("@signageos/common-types/dist/Device/Capabilities/ManagementCapabilities");
const PREFIX = 'native_commands';
function* handleNativeCommandMessage(messageTypePrefix, data, managementDriver) {
    switch (data.type) {
        case `${messageTypePrefix}.${PREFIX}.mdc.send_one`:
            return yield handleMdcSendOne(data, managementDriver, false);
        case `${messageTypePrefix}.${PREFIX}.mdc.send_one_raw`:
            return yield handleMdcSendOne(data, managementDriver, true);
        default:
            return null;
    }
}
exports.handleNativeCommandMessage = handleNativeCommandMessage;
function* nativeCommandHandler({ messageTypePrefix, data, managementDriver }) {
    return yield handleNativeCommandMessage(messageTypePrefix, data, managementDriver);
}
exports.default = nativeCommandHandler;
function handleMdcSendOne(data, managementDriver, raw) {
    return __awaiter(this, void 0, void 0, function* () {
        const isSupported = yield managementDriver.managementSupports(ManagementCapabilities_1.ManagementCapabilities.NATIVE_COMMANDS_MDC);
        if (!isSupported) {
            throw new Error('Native MDC commands are not supported on this device.');
        }
        if (raw) {
            const rawCommandResponse = yield managementDriver.nativeCommands.mdc.sendOneRaw(data.ipAddress, data.data);
            return { commandResponse: rawCommandResponse };
        }
        const commandResponse = yield managementDriver.nativeCommands.mdc.sendOne(data.ipAddress, data.command, data.data);
        return { commandResponse };
    });
}
//# sourceMappingURL=nativeCommandHandler.js.map