"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.handleManagementMessage = void 0;
const Orientation_1 = __importDefault(require("@signageos/common-types/dist/Device/Resolution/Orientation"));
const VideoOrientation_1 = __importDefault(require("@signageos/common-types/dist/Device/Resolution/VideoOrientation"));
const convertWeekday_1 = require("@signageos/lib/dist/Timer/convertWeekday");
const object_1 = require("@signageos/lib/dist/Utils/object");
const debug_1 = __importDefault(require("debug"));
const moment_timezone_1 = __importDefault(require("moment-timezone"));
const dependencyInjection_1 = require("../../../DI/dependencyInjection");
const dateTimeFacade_1 = require("../../../Management/Device/DateTime/dateTimeFacade");
const ManagementCapability_1 = __importDefault(require("../../../NativeDevice/Management/ManagementCapability"));
const TimerType_1 = __importStar(require("../../../NativeDevice/Timer/TimerType"));
const Property_1 = __importDefault(require("../../../Property/Property"));
const propertyStorage_1 = __importDefault(require("../../../Property/propertyStorage"));
const processCallback_1 = __importDefault(require("../../../Util/processCallback"));
const controlEnablingSagas_1 = require("../../Security/controlEnablingSagas");
const security_1 = require("../../Security/security");
const AppletSecurityError_1 = __importDefault(require("../Error/AppletSecurityError"));
const ErrorCodes_1 = __importDefault(require("../Error/ErrorCodes"));
const ErrorSuggestions_1 = __importDefault(require("../Error/ErrorSuggestions"));
const ManagementCapabilities_1 = require("@signageos/common-types/dist/Device/Capabilities/ManagementCapabilities");
const PowerActionType_1 = __importDefault(require("@signageos/actions/dist/Device/Power/PowerActionType"));
const debug = (0, debug_1.default)('@signageos/front-display:Front:Applet:Management:appletManagementHandler');
const PREFIX = 'management';
const DEBUG_PREFIX = 'debug';
function* handleManagementMessage(messageTypePrefix, data, managementDriver, frontDriver, propertyStorage, applicationVersion, timerStorage) {
    switch (data.type) {
        case `${messageTypePrefix}.${PREFIX}.supports`:
            return yield isCapabilitySupported(data, managementDriver);
        case `${messageTypePrefix}.${PREFIX}.initialize`:
            return yield handleInitialization(data, managementDriver);
        case `${messageTypePrefix}.${PREFIX}.get_application_type`:
            return yield handleGetApplicationType(managementDriver);
        case `${messageTypePrefix}.${PREFIX}.app_upgrade`: {
            return yield handleAppUpgrade(data, managementDriver);
        }
        case `${messageTypePrefix}.${PREFIX}.get_application_version`:
            return yield Promise.resolve({ applicationVersion });
        case `${messageTypePrefix}.${PREFIX}.get_model`:
            return yield handleGetModel(managementDriver);
        case `${messageTypePrefix}.${PREFIX}.get_serial_number`:
            return yield handleGetSerialNumber(managementDriver);
        case `${messageTypePrefix}.${PREFIX}.get_battery_status`:
            return yield handleGetBatteryStatus(managementDriver);
        case `${messageTypePrefix}.${PREFIX}.get_current_temperature`:
            return yield handleGetCurrentTemperature(managementDriver);
        case `${messageTypePrefix}.${PREFIX}.get_brand`:
            return yield handleGetBrand(managementDriver);
        case `${messageTypePrefix}.${PREFIX}.upload_screenshot`:
            return yield handleUploadScreenshot(data, managementDriver);
        case `${messageTypePrefix}.${PREFIX}.firmware_upgrade`: {
            return yield handleFirmwareUpgrade(data, managementDriver);
        }
        case `${messageTypePrefix}.${PREFIX}.get_firmware_version`:
            return yield handleGetFirmwareVersion(managementDriver);
        case `${messageTypePrefix}.${PREFIX}.get_firmware_type`:
            return yield handleGetFirmwareType(managementDriver);
        case `${messageTypePrefix}.${PREFIX}.get_volume`:
            return yield handleGetVolume(managementDriver);
        case `${messageTypePrefix}.${PREFIX}.set_volume`:
            return yield handleSetVolume(data, managementDriver);
        case `${messageTypePrefix}.${PREFIX}.set_screen_brightness`:
            return yield handleSetScreenBrightness(data, managementDriver, propertyStorage);
        case `${messageTypePrefix}.${PREFIX}.get_screen_brightness`:
            return yield handleGetScreenBrightness(managementDriver);
        case `${messageTypePrefix}.${PREFIX}.install_package`:
            return yield handleInstallPackage(data, managementDriver);
        case `${messageTypePrefix}.${PREFIX}.reboot_system`:
            return yield handleRebootSystem(managementDriver);
        case `${messageTypePrefix}.${PREFIX}.restart_app`:
            return yield handleRestartApp(managementDriver);
        case `${messageTypePrefix}.${PREFIX}.power_on_display`:
            return yield handlePowerOnDisplay(managementDriver);
        case `${messageTypePrefix}.${PREFIX}.power_off_display`:
            return yield handlePowerOffDisplay(managementDriver);
        case `${messageTypePrefix}.${PREFIX}.get_is_display_power_on`:
            return yield handleGetIsDisplayPowerOn(managementDriver);
        case `${messageTypePrefix}.${PREFIX}.resize_screen`:
            return yield handleResizeScreen(data, managementDriver);
        case `${messageTypePrefix}.${PREFIX}.get_screen_orientation`:
            return yield handleGetScreenOrientation(managementDriver);
        case `${messageTypePrefix}.${PREFIX}.get_timers`:
            return yield handleGetTimers(managementDriver);
        case `${messageTypePrefix}.${PREFIX}.set_timer`:
            return yield handleSetTimer(data, managementDriver);
        case `${messageTypePrefix}.${PREFIX}.get_proprietary_timers`:
            return yield handleGetProprietaryTimers(timerStorage);
        case `${messageTypePrefix}.${PREFIX}.set_proprietary_timer`:
            return yield handleSetProprietaryTimer(data, timerStorage);
        case `${messageTypePrefix}.${PREFIX}.delete_proprietary_timer`:
            return yield handleDeleteProprietaryTimer(data, timerStorage);
        case `${messageTypePrefix}.${PREFIX}.set_remote_control_enabled`:
            return yield handleSetRemoteControlEnabled(data, managementDriver);
        case `${messageTypePrefix}.${PREFIX}.get_is_remote_control_enabled`:
            return yield handleGetIsRemoteControlEnable(managementDriver);
        case `${messageTypePrefix}.${PREFIX}.get_current_time_with_timezone`:
            return yield handleGetCurrentTimeWithTimezone(managementDriver);
        case `${messageTypePrefix}.${PREFIX}.set_current_time_with_timezone`:
            return yield handleSetManualTimeWithTimezone(data, managementDriver);
        case `${messageTypePrefix}.${PREFIX}.set_ntp_time_with_timezone`:
            return yield handleSetNTPTimeWithTimezone(data, managementDriver);
        case `${messageTypePrefix}.${PREFIX}.set_debug`:
            return yield handleSetDebug(data, managementDriver);
        case `${messageTypePrefix}.${PREFIX}.is_enabled`:
            return yield handleIsDebugEnabled(managementDriver);
        case `${messageTypePrefix}.${PREFIX}.reset_settings`:
            return yield handleResetSettings(managementDriver);
        case `${messageTypePrefix}.${PREFIX}.factory_reset`:
            return yield handleFactoryReset(managementDriver);
        case `${messageTypePrefix}.${PREFIX}.set_pin_code`:
            return yield* handleSetPinCode(frontDriver, data);
        case `${messageTypePrefix}.${PREFIX}.get_pin_code`:
            return yield handleGetPinCode(frontDriver);
        case `${messageTypePrefix}.${PREFIX}.get_peer_recovery`:
            return yield handleGetPeerRecovery(managementDriver);
        case `${messageTypePrefix}.${PREFIX}.set_peer_recovery`:
            return yield handleSetPeerRecovery(data, managementDriver);
        case `${messageTypePrefix}.${PREFIX}.get_auto_recovery`:
            return yield handleGetAutoRecovery(managementDriver);
        case `${messageTypePrefix}.${PREFIX}.get_extendedmanagement_url`:
            return yield handleGetExtendedManagementUrl(managementDriver);
        case `${messageTypePrefix}.${PREFIX}.set_extendedmanagement_url`:
            return yield handleSetExtendedManagementUrl(data, managementDriver);
        case `${messageTypePrefix}.${PREFIX}.set_auto_recovery`:
            return yield handleSetAutoRecovery(data, managementDriver);
        case `${messageTypePrefix}.${DEBUG_PREFIX}.is_remote_enabled`:
            return yield handleRemoteDebug(propertyStorage);
        case `${messageTypePrefix}.${PREFIX}.set_hardware_acceleration`:
            return yield handleSetHardwareAcceleration(data, managementDriver);
        case `${messageTypePrefix}.${PREFIX}.is_hardware_acceleration_enabled`:
            return yield handleIsHardwareAccelerationEnabled(managementDriver);
        case `${messageTypePrefix}.${PREFIX}.set_scheduled_reboot`:
            return yield handleSetScheduledRebootAction(data, managementDriver);
        case `${messageTypePrefix}.${PREFIX}.get_scheduled_reboots`:
            return yield handleGetScheduledRebootActions(managementDriver);
        case `${messageTypePrefix}.${PREFIX}.remove_scheduled_reboot`:
            return yield handleRemoveScheduledRebootAction(data, managementDriver);
        case `${messageTypePrefix}.${PREFIX}.clear_scheduled_reboots`:
            return yield handleClearScheduledRebootActions(managementDriver);
        default:
            return null;
    }
}
exports.handleManagementMessage = handleManagementMessage;
function isCapabilitySupported(data, managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const capability = ManagementCapability_1.default[data.capability];
        if (typeof capability === 'undefined') {
            throw new Error('Invalid management capability');
        }
        const supports = yield managementDriver.managementSupports(capability);
        return { supports };
    });
}
function handleInitialization(data, managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        yield managementDriver.initialize(data.staticBaseUrl);
        return {};
    });
}
function handleGetApplicationType(managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const applicationType = yield managementDriver.getApplicationType();
        return { applicationType };
    });
}
function* handleAppUpgrade(data, managementDriver) {
    const { baseUrl, version, directUri } = data;
    if (directUri && (baseUrl || version)) {
        throw new Error('Invalid arguments for upgrade fw');
    }
    let finalizeCallback = undefined;
    const url = baseUrl || directUri;
    if (!url) {
        const { staticBaseUrl } = yield (0, dependencyInjection_1.awaitDependencies)(['staticBaseUrl']);
        finalizeCallback = yield managementDriver.appUpgrade(staticBaseUrl, version);
    }
    else {
        finalizeCallback = yield managementDriver.appUpgrade(url, version);
    }
    (0, processCallback_1.default)(finalizeCallback, { debugTag: 'appUpgrade()' });
    return {};
}
function handleGetModel(managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const model = yield managementDriver.systemInfo.getModel();
        return { model };
    });
}
function handleGetSerialNumber(managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const serialNumber = yield managementDriver.systemInfo.getSerialNumber();
        return { serialNumber };
    });
}
function handleGetBrand(managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const brand = yield managementDriver.systemInfo.getBrand();
        return { brand };
    });
}
function handleGetBatteryStatus(managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const batteryStatus = yield managementDriver.batteryGetStatus();
        return { batteryStatus };
    });
}
function handleGetCurrentTemperature(managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const currentTemperature = yield managementDriver.getCurrentTemperature();
        return { currentTemperature };
    });
}
function handleUploadScreenshot(data, managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const { uploadBaseUrl, computeHash } = data;
        const { url, imageInformations } = yield managementDriver.screenshotUpload(uploadBaseUrl, computeHash);
        return { screenshotUrl: url, aHash: imageInformations === null || imageInformations === void 0 ? void 0 : imageInformations.aHash };
    });
}
function* handleFirmwareUpgrade(data, managementDriver) {
    const { baseUrl, version, directUri } = data;
    if (directUri && (baseUrl || version)) {
        throw new Error('Invalid arguments for upgrade fw');
    }
    let finalizeCallback = undefined;
    const url = baseUrl || directUri;
    if (!url) {
        const { staticBaseUrl } = yield (0, dependencyInjection_1.awaitDependencies)(['staticBaseUrl']);
        finalizeCallback = yield managementDriver.firmwareUpgrade(staticBaseUrl, version);
    }
    else {
        finalizeCallback = yield managementDriver.firmwareUpgrade(url, version);
    }
    (0, processCallback_1.default)(finalizeCallback, { debugTag: 'firmwareUpgrade()' });
    return {};
}
function handleGetFirmwareVersion(managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const firmwareVersion = yield managementDriver.firmwareGetVersion();
        return { firmwareVersion };
    });
}
function handleGetFirmwareType(managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const firmwareType = yield managementDriver.firmwareGetType();
        return { firmwareType };
    });
}
function handleGetVolume(managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const volume = yield managementDriver.getVolume();
        return { volume };
    });
}
function handleSetScreenBrightness(data, managementDriver, propertyStorage) {
    return __awaiter(this, void 0, void 0, function* () {
        const { timeFrom1, brightness1, timeFrom2, brightness2 } = data;
        yield managementDriver.screenSetBrightness(timeFrom1, brightness1, timeFrom2, brightness2);
        yield propertyStorage.setValue(Property_1.default.BRIGHTNESS_SETTINGS, {
            timeFrom1: timeFrom1,
            brightness1: brightness1,
            timeFrom2: timeFrom2,
            brightness2: brightness2,
        });
        return {};
    });
}
function handleInstallPackage(data, managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const { baseUrl, packageName, version, build } = data;
        yield managementDriver.packageInstall(baseUrl, packageName, version, build);
        return {};
    });
}
function handleGetScreenBrightness(managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const screenBrightness = yield managementDriver.screenGetBrightness();
        return { screenBrightness };
    });
}
function handleSetVolume(data, managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const { volume } = data;
        yield managementDriver.setVolume(volume);
        return {};
    });
}
function handleRebootSystem(managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        yield managementDriver.systemReboot();
        return {};
    });
}
function handleRestartApp(managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        yield managementDriver.appRestart();
        return {};
    });
}
function handlePowerOnDisplay(managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        yield managementDriver.displayPowerOn();
        return {};
    });
}
function handlePowerOffDisplay(managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        yield managementDriver.displayPowerOff();
        return {};
    });
}
function handleGetIsDisplayPowerOn(managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const isDisplayPowerOn = yield managementDriver.displayIsPowerOn();
        return { isDisplayPowerOn };
    });
}
function handleResizeScreen(data, managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const { baseUrl, currentVersion } = data;
        const orientation = Orientation_1.default[data.orientation];
        const resolution = data.resolution === 'FULL_HD'
            ? { width: 1920, height: 1080 }
            : data.resolution === 'HD_READY'
                ? { width: 1280, height: 720 }
                : undefined;
        let videoOrientation = undefined;
        if (typeof orientation === 'undefined') {
            throw new Error('Invalid  orientation');
        }
        if (typeof resolution === 'undefined') {
            throw new Error('Invalid resolution');
        }
        if (data.videoOrientation) {
            videoOrientation = VideoOrientation_1.default[data.videoOrientation];
            if (typeof videoOrientation === 'undefined') {
                throw new Error('Invalid video orientation');
            }
        }
        const finalizeCallback = yield managementDriver.screenResize(baseUrl, orientation, resolution, currentVersion, videoOrientation);
        (0, processCallback_1.default)(finalizeCallback, { debugTag: 'screenResize()' });
        return {};
    });
}
function handleGetScreenOrientation(managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        debug('handleGetScreenOrientation');
        const currentOrientation = yield managementDriver.getCurrentOrientation();
        return { screenOrientation: Orientation_1.default[currentOrientation] };
    });
}
function handleGetTimers(managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const timers = yield managementDriver.getTimers();
        const appletTimers = timers.map((timer) => {
            return {
                type: (0, TimerType_1.numberToNativeTimerType)(timer.type),
                timeOn: timer.timeOn,
                timeOff: timer.timeOff,
                weekdays: convertWeekday_1.convertWeekday.fromTimerWeekday(timer.weekdays).toShort(),
                volume: timer.volume,
            };
        });
        return { timers: appletTimers };
    });
}
function handleSetTimer(data, managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const { timeOn, timeOff, volume } = data;
        const timerType = TimerType_1.default[data.timerType];
        const weekdays = convertWeekday_1.convertWeekday.fromShort(data.weekdays).toTimerWeekday();
        if (typeof timerType === 'undefined') {
            throw new Error('Invalid timer type');
        }
        weekdays.forEach((weekday) => {
            if (typeof weekday === 'undefined') {
                throw new Error('Invalid timer week day');
            }
        });
        yield managementDriver.setTimer(timerType, timeOn, timeOff, weekdays, volume);
        return {};
    });
}
function handleGetProprietaryTimers(timerStorage) {
    return __awaiter(this, void 0, void 0, function* () {
        const timersSettingsObject = yield timerStorage.getShortTimers();
        const timerTypes = (0, object_1.getObjectKeys)(timersSettingsObject);
        const timers = timerTypes.map((timerType) => {
            const timerSettings = timersSettingsObject[timerType];
            return {
                type: timerSettings.type,
                timeOn: timerSettings.timeOn,
                timeOff: timerSettings.timeOff,
                weekdays: timerSettings.weekdays,
            };
        });
        return { timers };
    });
}
function handleSetProprietaryTimer(data, timerStorage) {
    return __awaiter(this, void 0, void 0, function* () {
        const { timeOn, timeOff, timerType, weekdays, keepAppletRunning } = data;
        if (timeOn === null && timeOff === null) {
            // Backward compatibility for deleting timers
            return handleDeleteProprietaryTimer(data, timerStorage);
        }
        if (typeof timerType === 'undefined') {
            throw new Error('Invalid timer type');
        }
        weekdays.forEach((weekday) => {
            if (typeof weekday === 'undefined') {
                throw new Error('Invalid timer week day');
            }
        });
        yield timerStorage.setShortTimer({
            type: timerType,
            timeOn,
            timeOff,
            weekdays,
            keepAppletRunning,
        });
        return {};
    });
}
function handleDeleteProprietaryTimer(data, timerStorage) {
    return __awaiter(this, void 0, void 0, function* () {
        const { timerType } = data;
        if (typeof timerType === 'undefined') {
            throw new Error('Invalid timer type');
        }
        yield timerStorage.deleteShortTimer(timerType);
        return {};
    });
}
function handleSetRemoteControlEnabled(data, managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const { enabled } = data;
        const finalizeCallback = yield managementDriver.remoteControlSetEnabled(enabled);
        (0, processCallback_1.default)(finalizeCallback);
        return {};
    });
}
function handleGetIsRemoteControlEnable(managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const isRemoteControlEnabled = yield managementDriver.remoteControlIsEnabled();
        return { isRemoteControlEnabled };
    });
}
function handleGetCurrentTimeWithTimezone(managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const currentTimeWithTimezone = yield (0, dateTimeFacade_1.getCurrentTime)(managementDriver);
        return {
            currentTimeWithTimezone: {
                currentDate: new Date(currentTimeWithTimezone.timestamp),
                timezone: currentTimeWithTimezone.timezone || undefined,
                ntpServer: currentTimeWithTimezone.ntpServer,
                ntpEnabled: currentTimeWithTimezone.ntpEnabled,
            },
        };
    });
}
function handleSetManualTimeWithTimezone(data, managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        let timestampMs;
        if (data.currentDate instanceof Date) {
            // currentDate as Date is deprecated and this logic stays here simply for backwards compatibility
            timestampMs = (0, moment_timezone_1.default)(data.currentDate).valueOf();
        }
        else {
            timestampMs = moment_timezone_1.default
                .tz({
                year: data.currentDate.year,
                month: data.currentDate.month - 1,
                day: data.currentDate.day,
                hour: data.currentDate.hour,
                minute: data.currentDate.minute,
                second: data.currentDate.second,
            }, data.timezone)
                .valueOf();
        }
        const finalizeCallback = yield (0, dateTimeFacade_1.setNtpOrManualTime)(managementDriver, timestampMs, data.timezone);
        (0, processCallback_1.default)(finalizeCallback, { debugTag: 'setNtpOrManualTime()' });
        return {};
    });
}
function handleSetNTPTimeWithTimezone(data, managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const newCurrentMoment = (0, moment_timezone_1.default)();
        const finalizeCallback = yield (0, dateTimeFacade_1.setNtpOrManualTime)(managementDriver, newCurrentMoment.valueOf(), data.timezone, data.ntpServer);
        (0, processCallback_1.default)(finalizeCallback, { debugTag: 'setNtpOrManualTime()' });
        return {};
    });
}
function handleSetDebug(data, managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const { enabled } = data;
        const finalizeCallback = yield managementDriver.setDebug(enabled);
        (0, processCallback_1.default)(finalizeCallback, { debugTag: 'setDebug()' });
        return {};
    });
}
function handleIsDebugEnabled(managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const isEnabled = yield managementDriver.isDebugEnabled();
        return { isEnabled };
    });
}
function handleResetSettings(managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        yield managementDriver.resetSettings();
        return {};
    });
}
function handleFactoryReset(managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        yield managementDriver.factoryReset();
        return {};
    });
}
function* handleSetPinCode(frontDriver, { pinCode }) {
    if (pinCode === security_1.DEFAULT_OPEN_PIN_CODE) {
        throw new AppletSecurityError_1.default({
            kind: 'appletSecurityError',
            code: ErrorCodes_1.default.SECURITY_PIN_CODE_0000,
            message: 'The PIN code 0000 is not allowed.',
        });
    }
    yield frontDriver.security.setPin(pinCode);
    yield (0, controlEnablingSagas_1.putDevicePinChanged)(pinCode);
    return {};
}
function handleGetPinCode(frontDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const pinCode = yield frontDriver.security.getPin();
        if (!pinCode) {
            throw new AppletSecurityError_1.default({
                kind: 'appletSecurityError',
                code: ErrorCodes_1.default.SECURITY_PIN_CODE_NOT_SET_YET,
                message: 'The PIN code was not set yet.',
                suggestion: ErrorSuggestions_1.default.SECURITY_PIN_CODE_NOT_SET_YET,
            });
        }
        return { pinCode };
    });
}
function handleGetPeerRecovery(managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        return managementDriver.getPeerRecovery();
    });
}
function handleSetPeerRecovery(data, managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        yield managementDriver.setPeerRecovery(data.enabled
            ? { enabled: true, urlLauncherAddress: data.urlLauncherAddress }
            : { enabled: false, autoEnableTimeoutMs: data.autoEnableTimeoutMs });
        return {};
    });
}
function handleGetAutoRecovery(managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        return managementDriver.getAutoRecovery();
    });
}
function handleSetAutoRecovery(data, managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        yield managementDriver.setAutoRecovery(data.enabled
            ? { enabled: true, healthcheckIntervalMs: data.healthcheckIntervalMs }
            : { enabled: false, autoEnableTimeoutMs: data.autoEnableTimeoutMs });
        return {};
    });
}
function handleRemoteDebug(propertyStorage) {
    return __awaiter(this, void 0, void 0, function* () {
        const isEnabled = yield propertyStorage.getValueOrDefault(Property_1.default.DEBUG_WEINRE_ENABLED, false);
        return { isEnabled };
    });
}
function handleGetExtendedManagementUrl(managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const url = yield managementDriver.getExtendedManagementUrl();
        return { url };
    });
}
function handleSetExtendedManagementUrl(data, managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        yield managementDriver.setExtendedManagementUrl(data.url);
        return {};
    });
}
function handleSetHardwareAcceleration(data, managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const isSupported = yield managementDriver.managementSupports(ManagementCapabilities_1.ManagementCapabilities.HARDWARE_ACCELERATION);
        if (!isSupported) {
            throw new Error('Hardware acceleration is not supported on this device.');
        }
        yield managementDriver.setHardwareAcceleration(data.enabled);
        return {};
    });
}
function handleIsHardwareAccelerationEnabled(managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const enabled = yield managementDriver.isHardwareAccelerationEnabled();
        return { enabled };
    });
}
function handleSetScheduledRebootAction(data, managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const { rule } = data;
        // We need to generate unique id for each rule because there is
        // no backend what will do it for us
        const id = Math.random().toString(36).substring(2);
        yield managementDriver.powerExecutors.powerActionTimer.set(id, {
            powerType: PowerActionType_1.default.SYSTEM_REBOOT,
            weekdays: rule.weekdays,
            time: rule.time,
        });
        return {};
    });
}
function handleGetScheduledRebootActions(managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const rules = yield managementDriver.powerExecutors.powerActionTimer.rules();
        const actions = Object.entries(rules).map(([id, value]) => ({
            id,
            rule: {
                weekdays: value.weekdays,
                time: value.time,
            },
        }));
        return { actions };
    });
}
function handleRemoveScheduledRebootAction(data, managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        yield managementDriver.powerExecutors.powerActionTimer.unset(data.id);
        return {};
    });
}
function handleClearScheduledRebootActions(managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        yield managementDriver.powerExecutors.powerActionTimer.reset();
        return {};
    });
}
function* managementHandler({ messageTypePrefix, data, managementDriver, frontDriver, cacheDriver, applicationVersion, timerStorage, }) {
    const propertyStorage = (0, propertyStorage_1.default)(() => cacheDriver);
    return yield handleManagementMessage(messageTypePrefix, data, managementDriver, frontDriver, propertyStorage, applicationVersion, timerStorage);
}
exports.default = managementHandler;
//# sourceMappingURL=appletManagementHandler.js.map