"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.wifiEventEmitting = void 0;
const applicationActions_1 = require("@signageos/actions/dist/Application/applicationActions");
const effects_1 = require("redux-saga/effects");
const IWifi_1 = require("../../../../NativeDevice/Hardware/IWifi");
const ManagementCapability_1 = __importDefault(require("../../../../NativeDevice/Management/ManagementCapability"));
const channels_1 = require("../../../../ReduxSaga/channels");
const sendAppletMessage_1 = require("../../sendAppletMessage");
function* wifiEventEmitting(window, messageTypePrefix, getNativeDriver, getState) {
    yield (0, effects_1.takeEvery)(applicationActions_1.StartApplication, function* () {
        const nativeDriver = getNativeDriver();
        const supportsWifi = yield nativeDriver.managementSupports(ManagementCapability_1.default.WIFI);
        if (supportsWifi) {
            const wifiEventsChannel = createWifiChannel(getNativeDriver);
            yield (0, channels_1.takeEvery)(wifiEventsChannel, function* (event) {
                yield (0, sendAppletMessage_1.sendMessageToActiveAppletIfExists)(window, getState, {
                    type: messageTypePrefix + '.management.wifi.event_' + event,
                });
            });
        }
    });
}
exports.wifiEventEmitting = wifiEventEmitting;
function createWifiChannel(getNativeDriver) {
    const nativeDriver = getNativeDriver();
    const events = [
        IWifi_1.WifiEvent.CLIENT_ENABLED,
        IWifi_1.WifiEvent.CLIENT_CONNECTED,
        IWifi_1.WifiEvent.CLIENT_CONNECT_REJECTED,
        IWifi_1.WifiEvent.CLIENT_DISCONNECTED,
        IWifi_1.WifiEvent.AP_ENABLED,
        IWifi_1.WifiEvent.DISABLED,
    ];
    return (0, channels_1.createChannel)((putEvent) => {
        for (const event of events) {
            nativeDriver.wifi.on(event, () => putEvent(event));
        }
    });
}
//# sourceMappingURL=appletWifiSagas.js.map