"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.handleManagementNetworkMessage = void 0;
const PREFIX = 'management';
function* handleManagementNetworkMessage(messageTypePrefix, data, managementDriver) {
    switch (data.type) {
        case `${messageTypePrefix}.${PREFIX}.get_network_info`:
            return yield handleGetNetworkInfo(managementDriver);
        case `${messageTypePrefix}.${PREFIX}.get_network_interfaces`:
            return yield handleGetNetworkInterfaces(managementDriver);
        // deprecated
        case `${messageTypePrefix}.${PREFIX}.set_network_manual`:
            return yield handleSetNetworkManualLegacy(data, managementDriver);
        // deprecated
        case `${messageTypePrefix}.${PREFIX}.set_network_dhcp`:
            return yield handleSetNetworkDHCPLegacy(data, managementDriver);
        case `${messageTypePrefix}.${PREFIX}.set_network_manual_v2`:
            return yield handleSetNetworkManual(data, managementDriver);
        case `${messageTypePrefix}.${PREFIX}.set_network_dhcp_v2`:
            return yield handleSetNetworkDHCP(data, managementDriver);
        case `${messageTypePrefix}.${PREFIX}.disable_network_interface`:
            return yield handleDisableNetworkInterface(data, managementDriver);
        default:
            return null;
    }
}
exports.handleManagementNetworkMessage = handleManagementNetworkMessage;
function handleGetNetworkInterfaces(managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const interfaces = yield managementDriver.network.listInterfaces();
        return { interfaces };
    });
}
function handleGetNetworkInfo(managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const networkInterfaces = yield managementDriver.network.listInterfaces();
        const result = {};
        let activeInterface = null;
        for (let networkInterface of networkInterfaces) {
            switch (networkInterface.type) {
                case 'ethernet':
                    result.ethernetMacAddress = networkInterface.macAddress;
                    if (!activeInterface && networkInterface.localAddress) {
                        activeInterface = networkInterface;
                    }
                    break;
                case 'mobile':
                    if (!activeInterface && networkInterface.localAddress) {
                        activeInterface = networkInterface;
                    }
                    break;
                case 'wifi':
                    result.wifiMacAddress = networkInterface.macAddress;
                    if (!activeInterface && networkInterface.localAddress) {
                        result.wifiStrength = networkInterface.wifiStrength;
                        result.wifiSsid = networkInterface.wifiSsid;
                        activeInterface = networkInterface;
                    }
                    break;
                default:
                    break;
            }
        }
        if (activeInterface) {
            result.activeInterface = activeInterface.type;
            result.localAddress = activeInterface.localAddress;
            result.gateway = activeInterface.gateway;
            result.netmask = activeInterface.netmask;
            result.dns = activeInterface.dns;
            result.interfaceName = activeInterface.name;
        }
        return { networkInfo: result };
    });
}
function handleSetNetworkManual(data, managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        yield managementDriver.network.setManual(data.interfaceName, data.options);
        return {};
    });
}
function handleSetNetworkDHCP(data, managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        yield managementDriver.network.setDHCP(data.interfaceName);
        return {};
    });
}
function handleSetNetworkManualLegacy(data, managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const ifaceName = yield getNetworkInterfaceNameByType(data.options.interface, managementDriver);
        if (ifaceName) {
            yield managementDriver.network.setManual(ifaceName, {
                localAddress: data.options.localAddress,
                netmask: data.options.netmask,
                gateway: data.options.gateway,
                dns: data.options.dns,
            });
            return {};
        }
        else {
            throw new Error('network interface not found');
        }
    });
}
function handleSetNetworkDHCPLegacy(data, managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const ifaceName = yield getNetworkInterfaceNameByType(data.networkInterface, managementDriver);
        if (ifaceName) {
            yield managementDriver.network.setDHCP(ifaceName);
            return {};
        }
        else {
            throw new Error('network interface not found');
        }
    });
}
function handleDisableNetworkInterface(data, managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        yield managementDriver.network.disableInterface(data.interfaceName);
        return {};
    });
}
function getNetworkInterfaceNameByType(networkInterface, managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const ifaces = yield managementDriver.network.listInterfaces();
        for (const iface of ifaces) {
            if (iface.type === networkInterface) {
                return iface.name;
            }
        }
        return null;
    });
}
function* managementHandler({ messageTypePrefix, data, managementDriver }) {
    return yield handleManagementNetworkMessage(messageTypePrefix, data, managementDriver);
}
exports.default = managementHandler;
//# sourceMappingURL=appletManagementNetworkHandler.js.map