"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handleKeyUpAction = exports.inputKeysEmitting = void 0;
const effects_1 = require("redux-saga/effects");
const sendAppletMessage_1 = require("../sendAppletMessage");
const keyActions_1 = require("@signageos/actions/dist/Input/keyActions");
const KeyCode_1 = require("../../../NativeDevice/Input/KeyCode");
function* inputKeysEmitting(window, messageTypePrefix, getState) {
    yield (0, effects_1.takeEvery)(keyActions_1.HandleKeyUp, handleKeyUpAction, window, messageTypePrefix, getState);
}
exports.inputKeysEmitting = inputKeysEmitting;
function* handleKeyUpAction(window, messageTypePrefix, getState, action) {
    yield (0, sendAppletMessage_1.sendMessageToActiveAppletIfExists)(window, getState, {
        type: messageTypePrefix + '.input.keyup',
        keyCode: KeyCode_1.KeyCode[action.keyCode],
        keyName: action.keyCode,
    });
}
exports.handleKeyUpAction = handleKeyUpAction;
//# sourceMappingURL=appletKeySagas.js.map