import { StrictEffect } from 'redux-saga/effects';
import IFrontDriver from '../../NativeDevice/Front/IFrontDriver';
import ICacheDriver from '../../NativeDevice/ICacheDriver';
import IManagementDriver from '../../NativeDevice/Management/IManagementDriver';
import OfflineCache from '../../OfflineCache/OfflineCache';
import { SagaIteratorWithPromises } from '../../ReduxSaga/extendedEffects';
import ISynchronizer from '../../Synchronization/ISynchronizer';
import { IAnyTimerStorage } from '../../Timer/ITimerStorage';
import { IFrontState } from '../frontReducers';
import IMessage from './IMessage';
export interface IBaseHandlerParams {
    messageTypePrefix: string;
    data: IMessage;
    window: Window;
    cacheDriver: ICacheDriver;
}
export type IManagementHandlerParams = IBaseHandlerParams & {
    managementDriver: IManagementDriver;
    timerStorage: IAnyTimerStorage;
    applicationVersion: string;
};
export type IHandlerParams = IManagementHandlerParams & {
    frontDriver: IFrontDriver;
    getState: () => IFrontState;
    offlineCache: OfflineCache;
    synchronizer: ISynchronizer;
    appletUid: string;
    timingChecksum: string;
    shortAppletFilesUrl: boolean;
};
type HandlerReturn = Record<string, unknown> | null;
export type HandlerResult = SagaIteratorWithPromises<Promise<HandlerReturn> | StrictEffect<unknown, unknown>, Promise<HandlerReturn> | StrictEffect<unknown, unknown>, unknown> | HandlerReturn;
export {};
