"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const InternalError_1 = __importDefault(require("./InternalError"));
class InternalFileSystemError extends InternalError_1.default {
    constructor(parameters) {
        if (parameters.kind === 'internalFileSystemError') {
            super(Object.assign(Object.assign({}, parameters), { pathToDocs: InternalFileSystemError.PATH_TO_DOCS, kind: 'internalError' }));
        }
        else {
            super(Object.assign(Object.assign({}, parameters), { pathToDocs: InternalFileSystemError.PATH_TO_DOCS, kind: 'internalErrorWithOrigin' }));
        }
        this.name = 'InternalFileSystemError';
    }
}
InternalFileSystemError.PATH_TO_DOCS = '/api/js/js-file-system';
exports.default = InternalFileSystemError;
//# sourceMappingURL=InternalFileSystemError.js.map