"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const SosError_1 = __importDefault(require("./SosError"));
class InternalError extends SosError_1.default {
    constructor(parameters) {
        const { message, code, suggestion, pathToDocs } = parameters;
        const originMessage = parameters.kind === 'internalErrorWithOrigin' ? parameters.originMessage : undefined;
        super({
            kind: 'sosError',
            message: `${message}${originMessage ? ' - Original: ' + originMessage : ''}`,
            code,
            suggestion,
            pathToDocs,
        });
        this.name = 'InternalError';
        this.origin = parameters.kind === 'internalErrorWithOrigin' ? parameters.origin : undefined;
        this.originStack = parameters.kind === 'internalErrorWithOrigin' ? parameters.originStack : undefined;
        this.originMessage = originMessage;
    }
}
exports.default = InternalError;
//# sourceMappingURL=InternalError.js.map