"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handleDeviceInfoMessage = void 0;
const DEVICE_INFO_PREFIX = 'device_info';
function handleDeviceInfoMessage(messageTypePrefix, { type }, state) {
    switch (type) {
        case `${messageTypePrefix}.${DEVICE_INFO_PREFIX}.get_location`:
            return { location: state.device.location };
        case `${messageTypePrefix}.${DEVICE_INFO_PREFIX}.get_organization_tags`:
            return { tags: state.device.organizationTags };
        default:
            return null;
    }
}
exports.handleDeviceInfoMessage = handleDeviceInfoMessage;
function* deviceInfoHandler({ messageTypePrefix, data, getState }) {
    const state = getState();
    return handleDeviceInfoMessage(messageTypePrefix, data, state);
}
exports.default = deviceInfoHandler;
//# sourceMappingURL=appletDeviceInfoHandler.js.map