"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.browserEventEmitting = void 0;
const effects_1 = require("redux-saga/effects");
const sendAppletMessage_1 = require("../sendAppletMessage");
const IBrowser_1 = require("../../../NativeDevice/IBrowser");
const applicationActions_1 = require("../../../Application/applicationActions");
function* browserEventEmitting(window, messageTypePrefix, getNativeDriver, getState) {
    const browser = getNativeDriver().browser;
    const supports = yield browser.isSupported();
    if (!supports) {
        return;
    }
    const closeListener = (event) => {
        (0, sendAppletMessage_1.sendMessageToActiveAppletIfExists)(window, getState, {
            type: messageTypePrefix + '.browser.closed',
            reason: event.reason,
        });
    };
    browser.addListener(IBrowser_1.EventType.CLOSE, closeListener);
    try {
        yield (0, effects_1.take)(applicationActions_1.StopApplication);
    }
    finally {
        browser.removeListener(IBrowser_1.EventType.CLOSE, closeListener);
    }
}
exports.browserEventEmitting = browserEventEmitting;
//# sourceMappingURL=appletBrowserSagas.js.map