"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDefaultAppletBinaries = exports.AppletBinaryDownloader = void 0;
const path_1 = __importDefault(require("path"));
const url = __importStar(require("url"));
const appletFileNameHelpers_1 = __importDefault(require("./appletFileNameHelpers"));
const synchronousDecorator_1 = require("../../Lock/synchronousDecorator");
const retriableDecorator_1 = require("../../Util/retriableDecorator");
class AppletBinaryDownloader {
    constructor(shortAppletFilesUrl, offlineCache, getStaticBaseUrl) {
        this.offlineCache = offlineCache;
        this.getStaticBaseUrl = getStaticBaseUrl;
        this.appletFileNameHelpers = (0, appletFileNameHelpers_1.default)(shortAppletFilesUrl);
    }
    getOrDownloadAppletBinaries(appletUid, appletVersion, isPackage, frontAppletVersion, appletVersionPostfix, defaultTimingData) {
        return __awaiter(this, void 0, void 0, function* () {
            if ((defaultTimingData === null || defaultTimingData === void 0 ? void 0 : defaultTimingData.appletUid) === appletUid && (defaultTimingData === null || defaultTimingData === void 0 ? void 0 : defaultTimingData.appletVersion) === appletVersion) {
                return getDefaultAppletBinaries(defaultTimingData.appletBinaryFile, defaultTimingData.appletFrontAppletJsFile, window.location.href);
            }
            else {
                if (isPackage) {
                    return yield this.downloadAppletPackageToLocalStorage(appletUid, appletVersion, appletVersionPostfix);
                }
                else {
                    return yield this.downloadAppletBinariesToLocalStorage(appletUid, appletVersion, frontAppletVersion, appletVersionPostfix);
                }
            }
        });
    }
    getOrDownloadFrontAppletJsFile(frontAppletVersion) {
        return __awaiter(this, void 0, void 0, function* () {
            const frontAppletJsFileName = this.appletFileNameHelpers.getFrontAppletJsFileName(frontAppletVersion);
            const existsFrontAppletJsFile = yield this.offlineCache.fileExists(frontAppletJsFileName);
            if (!existsFrontAppletJsFile) {
                const staticBaseUrl = this.getStaticBaseUrl(); // It has to be retrieved here to prevent error when loading from offline cache
                const frontAppletJsUri = staticBaseUrl + '/lib/front-applet/' + frontAppletVersion + '/bundle.js';
                yield this.offlineCache.retriableDownloadFile(5, frontAppletJsFileName, frontAppletJsUri, undefined, true);
            }
            return yield this.offlineCache.getFile(frontAppletJsFileName);
        });
    }
    downloadAppletBinariesToLocalStorage(appletUid, appletVersion, frontAppletVersion, appletVersionPostfix) {
        return __awaiter(this, void 0, void 0, function* () {
            const appletBinaryFileName = this.appletFileNameHelpers.getAppletBinaryFileName(appletUid, appletVersion, appletVersionPostfix);
            const existsAppletBinaryFile = yield this.offlineCache.fileExists(appletBinaryFileName);
            if (!existsAppletBinaryFile) {
                const staticBaseUrl = this.getStaticBaseUrl(); // It has to be retrieved here to prevent error when loading from offline cache
                const appletUri = this.appletFileNameHelpers.getAppletBinaryFileUri(staticBaseUrl, appletUid, appletVersion, appletVersionPostfix);
                try {
                    yield this.offlineCache.retriableDownloadFile(5, appletBinaryFileName, appletUri, undefined, true);
                }
                catch (error) {
                    // TODO this only console logging of error can has negative effect and should be refactored
                    console.error('Error during load last applet binary', error);
                }
            }
            return {
                frontAppletJsFile: frontAppletVersion ? yield this.getOrDownloadFrontAppletJsFile(frontAppletVersion) : null,
                appletBinaryFile: yield this.offlineCache.getFile(appletBinaryFileName),
            };
        });
    }
    downloadAppletPackageToLocalStorage(appletUid, appletVersion, appletVersionPostfix) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.ensurePackageIsDownloaded(appletUid, appletVersion, appletVersionPostfix);
            yield this.ensurePackageIsExtracted(appletUid, appletVersion, appletVersionPostfix);
            const mainFilePath = yield this.getPackageMainFilePath(appletUid, appletVersion, appletVersionPostfix);
            return {
                frontAppletJsFile: null, // multi-file package applets has front-applet bundled always
                appletBinaryFile: yield this.offlineCache.getFile(mainFilePath),
            };
        });
    }
    ensurePackageIsDownloaded(appletUid, appletVersion, appletVersionPostfix) {
        return __awaiter(this, void 0, void 0, function* () {
            const packageFilePath = this.appletFileNameHelpers.getAppletPackageFilePath(appletUid, appletVersion, appletVersionPostfix);
            const existsPackageFile = yield this.offlineCache.fileExists(packageFilePath);
            if (!existsPackageFile) {
                const staticBaseUrl = this.getStaticBaseUrl(); // It has to be retrieved here to prevent error when loading from offline cache
                const packageUri = this.appletFileNameHelpers.getAppletPackageFileUri(staticBaseUrl, appletUid, appletVersion, appletVersionPostfix);
                yield this.offlineCache.retriableDownloadFile(5, packageFilePath, packageUri, undefined, true);
            }
        });
    }
    ensurePackageIsExtracted(appletUid, appletVersion, appletVersionPostfix) {
        return __awaiter(this, void 0, void 0, function* () {
            const configFilePath = this.appletFileNameHelpers.getAppletPackageConfigFilePath(appletUid, appletVersion, appletVersionPostfix);
            const packageFilePath = this.appletFileNameHelpers.getAppletPackageFilePath(appletUid, appletVersion, appletVersionPostfix);
            const packageDirectoryPath = this.appletFileNameHelpers.getAppletPackageDirectoryPath(appletUid, appletVersion, appletVersionPostfix);
            const existsConfigFile = yield this.offlineCache.fileExists(configFilePath);
            if (!existsConfigFile) {
                yield this.offlineCache.extractFile(packageFilePath, packageDirectoryPath, 'zip', true);
            }
        });
    }
    getPackageMainFilePath(appletUid, appletVersion, appletVersionPostfix) {
        return __awaiter(this, void 0, void 0, function* () {
            const configFilePath = this.appletFileNameHelpers.getAppletPackageConfigFilePath(appletUid, appletVersion, appletVersionPostfix);
            const configContent = yield this.offlineCache.readFile(configFilePath);
            const config = JSON.parse(configContent);
            if (typeof config.main !== 'string') {
                throw new Error(`Main file of applet package is not specified: ${appletUid}, ${appletVersion}, ${appletVersionPostfix}, ${configContent}`);
            }
            const packageDirectoryPath = this.appletFileNameHelpers.getAppletPackageDirectoryPath(appletUid, appletVersion, appletVersionPostfix);
            const mainFilePath = packageDirectoryPath + '/' + config.main;
            return mainFilePath;
        });
    }
}
exports.AppletBinaryDownloader = AppletBinaryDownloader;
__decorate([
    (0, synchronousDecorator_1.synchronous)(),
    (0, retriableDecorator_1.retriable)({ count: 10, initialTimeoutMs: 1e3, maxTimeoutMs: 5 * 60e3 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String, Boolean, String, String, Object]),
    __metadata("design:returntype", Promise)
], AppletBinaryDownloader.prototype, "getOrDownloadAppletBinaries", null);
function resolveFrontAppletJsFile(frontAppletJsUriOrPath, defaultBaseUri) {
    if (typeof frontAppletJsUriOrPath === 'undefined') {
        return null;
    }
    if (isUrlLike(frontAppletJsUriOrPath)) {
        return { localUri: frontAppletJsUriOrPath };
    }
    frontAppletJsUriOrPath = getPathname(getAbsoluteUri(frontAppletJsUriOrPath, defaultBaseUri));
    return { localUri: getAbsoluteUri(frontAppletJsUriOrPath, defaultBaseUri) };
}
function getDefaultAppletBinaries(appletBinaryUriOrPath, frontAppletJsUriOrPath, defaultBaseUri) {
    const appletBinaryUri = ensureAbsoluteUri(appletBinaryUriOrPath, defaultBaseUri);
    return {
        appletBinaryFile: { localUri: appletBinaryUri },
        frontAppletJsFile: resolveFrontAppletJsFile(frontAppletJsUriOrPath, defaultBaseUri),
    };
}
exports.getDefaultAppletBinaries = getDefaultAppletBinaries;
function ensureAbsoluteUri(uriOrPath, defaultBaseUri) {
    if (isUrlLike(uriOrPath)) {
        return uriOrPath;
    }
    return getAbsoluteUri(uriOrPath, defaultBaseUri);
}
function getPathname(uri) {
    return url.parse(uri).pathname;
}
function getAbsoluteUri(filePath, baseUri) {
    const parsedBaseUri = url.parse(baseUri);
    if (!parsedBaseUri.pathname) {
        throw new Error(`Invalid applet binary file path`);
    }
    const pathname = getAbsolutePathname(filePath, parsedBaseUri.pathname);
    return url.format(Object.assign(Object.assign({}, parsedBaseUri), { pathname, search: undefined }));
}
function getAbsolutePathname(filePath, basePathname) {
    if (path_1.default.isAbsolute(filePath)) {
        return filePath;
    }
    const segmentedBasePathname = basePathname.split('/');
    segmentedBasePathname[segmentedBasePathname.length - 1] = filePath;
    const pathname = segmentedBasePathname.join('/');
    return pathname;
}
function isUrlLike(uriOrPath) {
    return url.parse(uriOrPath).protocol !== null;
}
//# sourceMappingURL=AppletBinaryDownloader.js.map