import { IHeaders } from '../NativeDevice/fileSystem';
/**
 * Fetches remote content headers using HTTP HEAD method.
 */
export type IHttpHeadFetcher = (uri: string, headers?: IHeaders) => Promise<IHttpHeadResponse>;
export type IHttpHeadResponse = {
    readonly ok: boolean;
    readonly headers: IHttpHeaders;
};
type IHttpHeaders = Partial<Record<string, string>>;
/**
 * Allows fetching remote content headers using `Window.fetch` API.
 */
export declare function createWindowHttpHeadFetcher(window: Pick<Window, 'fetch'>): IHttpHeadFetcher;
export {};
