"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateFreeSpace = exports.calculateReservedSpace = exports.RESERVED_SPACE_PERCENTAGE = exports.trimSlashesAndDots = void 0;
const path_1 = require("path");
const surroundingSlash = new RegExp('^/|/$', 'g');
function trimSlashesAndDots(filePath) {
    filePath = path_1.posix.normalize(filePath);
    // Remove leading and trailing '/'
    filePath = filePath.replace(surroundingSlash, '');
    if (filePath === '.') {
        return '';
    }
    return filePath;
}
exports.trimSlashesAndDots = trimSlashesAndDots;
// In this folders append or write actions can still write
const IGNORED_FOLDERS = ['.offline-actions', '.logs'];
// Reserved space by type as percentage
exports.RESERVED_SPACE_PERCENTAGE = 10;
/** Test only. */
function calculateReservedSpace(capacity, reservedPercentage) {
    // Round up, so we're on the safe side.
    return Math.ceil((capacity * reservedPercentage) / 100);
}
exports.calculateReservedSpace = calculateReservedSpace;
/** Test only. */
function validateFreeSpace(storageUnit, filePath, fileSizeBytes) {
    return __awaiter(this, void 0, void 0, function* () {
        if (typeof fileSizeBytes !== 'number') {
            return true;
        }
        // TODO parameterize ignored folders/paths
        if (IGNORED_FOLDERS.some((folder) => filePath === folder || filePath.startsWith(folder + '/'))) {
            return true;
        }
        const remainingSpace = storageUnit.usableSpace - fileSizeBytes;
        return remainingSpace >= 0;
    });
}
exports.validateFreeSpace = validateFreeSpace;
//# sourceMappingURL=fileSystemHelper.js.map