"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createBrowserFileSystem = void 0;
const querystring = __importStar(require("querystring"));
const IndexedDBFileSystem_1 = __importDefault(require("./IndexedDB/IndexedDBFileSystem"));
const ProprietaryFileSystem_1 = __importDefault(require("./ProprietaryFileSystem"));
var FileSystemType;
(function (FileSystemType) {
    /**
     * Standard technology based on IndexedDB and Cache API.
     */
    FileSystemType["IndexedDB"] = "indexed_db";
    /**
     * Obsolete technology based on File API.
     * Available only in Chromium based browsers.
     * https://www.w3.org/TR/file-system-api/
     */
    FileSystemType["Webkit"] = "webkit";
})(FileSystemType || (FileSystemType = {}));
function createBrowserFileSystem(window, namespace, storageBaseUrl) {
    const queryParams = parseQueryParams(window.location.search);
    let fileSystemType = queryParams.fileSystem;
    const supportsIndexedDB = 'indexedDB' in window && 'caches' in window;
    if (!fileSystemType && !supportsIndexedDB) {
        console.warn('Running emulator on very old system. Using legacy webkit filesystem instead of indexedDB filesystem.');
        fileSystemType = FileSystemType.Webkit;
    }
    if (fileSystemType === FileSystemType.Webkit) {
        handleWebkitFileSystemWarning(window);
        return new ProprietaryFileSystem_1.default(window, window.PERSISTENT, Number.MAX_SAFE_INTEGER);
    }
    else {
        handleIndexedDBFileSystemWarning(window);
        return new IndexedDBFileSystem_1.default(window.indexedDB, window.caches, storageBaseUrl, namespace);
    }
}
exports.createBrowserFileSystem = createBrowserFileSystem;
function parseQueryParams(search) {
    return querystring.parse(search.slice(1));
}
function handleWebkitFileSystemWarning(window) {
    const requestFileSystem = window.requestFileSystem || window.webkitRequestFileSystem;
    if (!requestFileSystem) {
        console.warn('File System API is not supported by this browser.\n' +
            'https://developer.mozilla.org/en-US/docs/Web/API/FileSystem\n\n' +
            'Consider using IndexedDB file system (add query parameter `?fileSystem=indexed_db` into the URL).\n');
    }
}
function handleIndexedDBFileSystemWarning(window) {
    if (!window.indexedDB) {
        console.warn('IndexedDB is not supported by this browser.\n' +
            'https://developer.mozilla.org/en-US/docs/Web/API/IndexedDB_API\n\n' +
            'Consider using File System API (add query parameter `?fileSystem=webkit` into the URL).\n');
    }
    if (!window.caches) {
        if (window.isSecureContext) {
            console.warn('Cache API is not supported by this browser.\n' +
                'https://developer.mozilla.org/en-US/docs/Web/API/Cache\n\n' +
                'Consider using File System API (add query parameter `?fileSystem=webkit` into the URL).\n');
        }
        else {
            console.warn('Cache API requires a secure context.\n' +
                'https://developer.mozilla.org/en-US/docs/Web/API/Cache\n' +
                'https://developer.mozilla.org/en-US/docs/Web/Security/Secure_Contexts\n\n' +
                `Current origin ${window.location.origin} is not secure. You have to navigate to a secure origin.\n` +
                `Try following addresses:\n`);
            const sslUrl = new URL(window.location.href);
            if (sslUrl.protocol === 'http:') {
                sslUrl.protocol = 'https';
                console.warn(sslUrl.toString());
            }
            const localhostUrl = new URL(window.location.href);
            if (localhostUrl.hostname !== 'localhost') {
                localhostUrl.hostname = 'localhost';
                console.warn(localhostUrl.toString());
            }
            const localUrl = new URL(window.location.href);
            if (localUrl.hostname !== '127.0.0.1') {
                localUrl.hostname = '127.0.0.1';
                console.warn(localUrl.toString());
            }
        }
    }
}
//# sourceMappingURL=browserFileSystemFactory.js.map