import IFrontFileSystem, { IArchiveInfo, ICopyFileOptions, IMoveFileOptions } from '../NativeDevice/IFileSystem';
import { IFilePath, IFile, IStorageUnit, IHeaders } from '../NativeDevice/fileSystem';
import HashAlgorithm from '../NativeDevice/HashAlgorithm';
export default class ProprietaryFileSystem implements IFrontFileSystem {
    private window;
    private fileSystemType;
    private storageSizeBytes;
    private fileSystem;
    private storageUnit;
    constructor(window: Window, fileSystemType?: number, storageSizeBytes?: number);
    initialize(): Promise<void>;
    listFiles(directoryPath: IFilePath): Promise<IFilePath[]>;
    getFile(filePath: IFilePath): Promise<IFile | null>;
    readFile(filePath: IFilePath): Promise<string>;
    writeFile(filePath: IFilePath, contents: string): Promise<void>;
    appendFile(filePath: IFilePath, contents: string): Promise<void>;
    exists(filePath: IFilePath): Promise<boolean>;
    downloadFile(filePath: IFilePath, sourceUri: string, headers?: IHeaders): Promise<void>;
    uploadFile(filePath: IFilePath, uri: string, formKey: string, headers?: {
        [key: string]: string;
    }): Promise<string>;
    deleteFile(filePath: IFilePath, recursive: boolean): Promise<void>;
    copyFile(sourceFilePath: IFilePath, destinationFilePath: IFilePath, options?: ICopyFileOptions): Promise<void>;
    moveFile(sourceFilePath: IFilePath, destinationFilePath: IFilePath, options?: IMoveFileOptions): Promise<void>;
    link(_sourceFilePath: IFilePath, _destinationFilePath: IFilePath): Promise<void>;
    createDirectory(directoryPath: IFilePath): Promise<void>;
    isDirectory(filePath: IFilePath): Promise<boolean>;
    extractFile(archiveFilePath: IFilePath, destinationDirectoryPath: IFilePath, method: string): Promise<void>;
    createArchive(_archiveFilePath: IFilePath, _archiveEntries: IFilePath[]): Promise<void>;
    getFileChecksum(filePath: IFilePath, hashType: HashAlgorithm): Promise<string>;
    listStorageUnits(): Promise<IStorageUnit[]>;
    onStorageUnitsChanged(_listener: () => void): void;
    getArchiveInfo(archiveFilePath: IFilePath): Promise<IArchiveInfo>;
    wipeout(): Promise<void>;
    private ensureDirectory;
    private getDirectoryUsageSize;
    private getFileText;
    private getFileBlob;
    private fetchFile;
    private getFileSystem;
    private getEntry;
    private getFileEntry;
    private getDirectoryEntry;
    private readDirectoryEntries;
    private createWriter;
    private getFileMatadata;
    private writeBlobToFileEntry;
    private detectMimeTypeOfUri;
    private fetchWithFailoverUsingMetadata;
    private fetchWithFailover;
    private simpleFetch;
    private getMetadata;
    private setMetadata;
    private copyOrMoveMetadata;
    private deleteMetadata;
    private getMetadataFilePath;
    private getSimpleHeaders;
    private getHeadersObject;
    private requestFileSystem;
    private fetchOrDecodeDataUri;
}
