import { IFile, IFilePath, IHeaders, IStorageUnit } from '../NativeDevice/fileSystem';
import HashAlgorithm from '../NativeDevice/HashAlgorithm';
import IFileSystem, { IArchiveInfo, ICopyFileOptions, IMoveFileOptions } from '../NativeDevice/IFileSystem';
import { IHttpHeadFetcher } from './httpHeadFetchers';
export declare class FileSystemWithReservedSpace implements IFileSystem {
    private readonly fileSystem;
    private readonly httpHeadFetcher;
    private readonly reservedPercentage;
    constructor(fileSystem: IFileSystem, httpHeadFetcher: IHttpHeadFetcher, reservedPercentage: number);
    writeFile(filePath: IFilePath, contents: string): Promise<void>;
    listStorageUnits(): Promise<IStorageUnit[]>;
    onStorageUnitsChanged(listener: () => void): Promise<void>;
    listFiles(directoryPath: IFilePath): Promise<IFilePath[]>;
    getFile(filePath: IFilePath): Promise<IFile | null>;
    readFile(filePath: IFilePath): Promise<string>;
    appendFile(filePath: IFilePath, contents: string): Promise<void>;
    exists(filePath: IFilePath): Promise<boolean>;
    downloadFile(filePath: IFilePath, sourceUri: string, headers?: IHeaders | undefined): Promise<void>;
    uploadFile(filePath: IFilePath, uri: string, formKey: string, headers?: IHeaders | undefined): Promise<string | undefined>;
    deleteFile(filePath: IFilePath, recursive: boolean): Promise<void>;
    copyFile(sourceFilePath: IFilePath, destinationFilePath: IFilePath, options?: ICopyFileOptions | undefined): Promise<void>;
    moveFile(sourceFilePath: IFilePath, destinationFilePath: IFilePath, options?: IMoveFileOptions | undefined): Promise<void>;
    link(sourceFilePath: IFilePath, destinationFilePath: IFilePath): Promise<void>;
    getFileChecksum(filePath: IFilePath, hashType: HashAlgorithm): Promise<string>;
    extractFile(archiveFilePath: IFilePath, destinationDirectoryPath: IFilePath, method: string): Promise<void>;
    createArchive(archiveFilePath: IFilePath, archiveEntries: IFilePath[]): Promise<void>;
    createDirectory(directoryPath: IFilePath): Promise<void>;
    isDirectory(filePath: IFilePath): Promise<boolean>;
    getArchiveInfo(archiveFilePath: IFilePath): Promise<IArchiveInfo>;
    wipeout(): Promise<void>;
    /** @deprecated Test only. */
    getExtendedFileSystem(): IFileSystem;
    private getStorageUnitByType;
}
export declare function createFileSystemWithReservedSpaceWithWindowHttpHeadFetcher(fileSystem: IFileSystem, window: Pick<Window, 'fetch'>, reservedPercentage: number): IFileSystem;
