"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const path_1 = require("path");
const methodCache_1 = require("../Cache/methodCache");
const HashAlgorithm_1 = __importDefault(require("../NativeDevice/HashAlgorithm"));
const FILE_SYSTEM_CACHE_KEY = 'CachedFileSystem';
/**
 * Proxy file system implementation that caches results in memory for better performance
 */
class CachedFileSystem {
    constructor(fileSystem, identification) {
        this.fileSystem = fileSystem;
        this.identification = identification;
        this.fileSystem.onStorageUnitsChanged(() => {
            (0, methodCache_1.clearCache)(`${FILE_SYSTEM_CACHE_KEY}.${this.identification}.`);
        });
    }
    initialize() {
        return __awaiter(this, void 0, void 0, function* () {
            // do nothing
        });
    }
    getCacheKey(filePath, method) {
        if (filePath === null) {
            return `${FILE_SYSTEM_CACHE_KEY}.${this.identification}.${method}`;
        }
        else {
            return `${FILE_SYSTEM_CACHE_KEY}.${this.identification}.${method}.${filePath.storageUnit.type}/${filePath.filePath}`;
        }
    }
    getParentDirectory(filePath) {
        const parentFilePath = path_1.posix.dirname(filePath.filePath);
        return {
            storageUnit: filePath.storageUnit,
            filePath: parentFilePath === '.' ? '' : parentFilePath,
        };
    }
    writeFile(filePath, contents) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.fileSystem.writeFile(filePath, contents);
        });
    }
    appendFile(filePath, contents) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.fileSystem.appendFile(filePath, contents);
        });
    }
    readFile(filePath) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.fileSystem.readFile(filePath);
        });
    }
    copyFile(sourceFilePath, destinationFilePath, options) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.fileSystem.copyFile(sourceFilePath, destinationFilePath, options);
        });
    }
    listFiles(directoryPath) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.fileSystem.listFiles(directoryPath);
        });
    }
    getFile(filePath) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.fileSystem.getFile(filePath);
        });
    }
    exists(filePath) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.fileSystem.exists(filePath);
        });
    }
    downloadFile(destinationFilePath, sourceUri, headers) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.fileSystem.downloadFile(destinationFilePath, sourceUri, headers);
        });
    }
    uploadFile(filePath, uri, formKey, headers) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.fileSystem.uploadFile(filePath, uri, formKey, headers);
        });
    }
    deleteFile(filePath, recursive) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.fileSystem.deleteFile(filePath, recursive);
        });
    }
    moveFile(sourceFilePath, destinationFilePath, options) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.fileSystem.moveFile(sourceFilePath, destinationFilePath, options);
        });
    }
    link(sourceFilePath, destinationFilePath) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.fileSystem.link(sourceFilePath, destinationFilePath);
        });
    }
    getFileChecksum(filePath, hashType) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.fileSystem.getFileChecksum(filePath, hashType);
        });
    }
    extractFile(archiveFilePath, destinationDirectoryPath, method) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.fileSystem.extractFile(archiveFilePath, destinationDirectoryPath, method);
        });
    }
    createArchive(archiveFilePath, archiveEntries) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.fileSystem.createArchive(archiveFilePath, archiveEntries);
        });
    }
    createDirectory(directoryPath) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.fileSystem.createDirectory(directoryPath);
        });
    }
    isDirectory(filePath) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.fileSystem.isDirectory(filePath);
        });
    }
    listStorageUnits() {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.fileSystem.listStorageUnits();
        });
    }
    getArchiveInfo(archiveFilePath) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.fileSystem.getArchiveInfo(archiveFilePath);
        });
    }
    onStorageUnitsChanged(listener) {
        return this.fileSystem.onStorageUnitsChanged(listener);
    }
    wipeout() {
        return __awaiter(this, void 0, void 0, function* () {
            return this.fileSystem.wipeout();
        });
    }
}
exports.default = CachedFileSystem;
__decorate([
    (0, methodCache_1.cacheInvalidating)((self, filePath) => [
        self.getCacheKey(self.getParentDirectory(filePath), 'listFiles'),
        self.getCacheKey(filePath, 'readFile'),
        self.getCacheKey(filePath, 'getFile'),
        self.getCacheKey(filePath, 'exists'),
        self.getCacheKey(filePath, 'getFileChecksum'),
        self.getCacheKey(filePath, 'getArchiveInfo'),
        self.getCacheKey(null, 'listStorageUnits'),
    ]),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, String]),
    __metadata("design:returntype", Promise)
], CachedFileSystem.prototype, "writeFile", null);
__decorate([
    (0, methodCache_1.cacheInvalidating)((self, filePath) => [
        self.getCacheKey(self.getParentDirectory(filePath), 'listFiles'),
        self.getCacheKey(filePath, 'readFile'),
        self.getCacheKey(filePath, 'getFile'),
        self.getCacheKey(filePath, 'exists'),
        self.getCacheKey(filePath, 'getFileChecksum'),
        self.getCacheKey(filePath, 'getArchiveInfo'),
        self.getCacheKey(null, 'listStorageUnits'),
    ]),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, String]),
    __metadata("design:returntype", Promise)
], CachedFileSystem.prototype, "appendFile", null);
__decorate([
    (0, methodCache_1.cachedOperation)((self, filePath) => self.getCacheKey(filePath, 'readFile')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], CachedFileSystem.prototype, "readFile", null);
__decorate([
    (0, methodCache_1.cacheInvalidating)((self, _sourceFilePath, destinationFilePath) => [
        self.getCacheKey(self.getParentDirectory(destinationFilePath), 'listFiles'),
        self.getCacheKey(destinationFilePath, 'readFile'),
        self.getCacheKey(destinationFilePath, 'getFile'),
        self.getCacheKey(destinationFilePath, 'exists'),
        self.getCacheKey(destinationFilePath, 'getFileChecksum'),
        self.getCacheKey(destinationFilePath, 'isDirectory'),
        self.getCacheKey(destinationFilePath, 'getArchiveInfo'),
        self.getCacheKey(null, 'listStorageUnits'),
    ], true),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object, Object]),
    __metadata("design:returntype", Promise)
], CachedFileSystem.prototype, "copyFile", null);
__decorate([
    (0, methodCache_1.cachedOperation)((self, directoryPath) => self.getCacheKey(directoryPath, 'listFiles')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], CachedFileSystem.prototype, "listFiles", null);
__decorate([
    (0, methodCache_1.cachedOperation)((self, filePath) => self.getCacheKey(filePath, 'getFile')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], CachedFileSystem.prototype, "getFile", null);
__decorate([
    (0, methodCache_1.cachedOperation)((self, filePath) => self.getCacheKey(filePath, 'exists')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], CachedFileSystem.prototype, "exists", null);
__decorate([
    (0, methodCache_1.cacheInvalidating)((self, destinationFilePath) => [
        self.getCacheKey(self.getParentDirectory(destinationFilePath), 'listFiles'),
        self.getCacheKey(destinationFilePath, 'readFile'),
        self.getCacheKey(destinationFilePath, 'getFile'),
        self.getCacheKey(destinationFilePath, 'exists'),
        self.getCacheKey(destinationFilePath, 'getFileChecksum'),
        self.getCacheKey(destinationFilePath, 'getArchiveInfo'),
        self.getCacheKey(null, 'listStorageUnits'),
    ]),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, String, Object]),
    __metadata("design:returntype", Promise)
], CachedFileSystem.prototype, "downloadFile", null);
__decorate([
    (0, methodCache_1.cacheInvalidating)((self, filePath) => [
        self.getCacheKey(self.getParentDirectory(filePath), 'listFiles'),
        self.getCacheKey(filePath, 'readFile'),
        self.getCacheKey(filePath, 'getFile'),
        self.getCacheKey(filePath, 'exists'),
        self.getCacheKey(filePath, 'getFileChecksum'),
        self.getCacheKey(filePath, 'isDirectory'),
        self.getCacheKey(filePath, 'getArchiveInfo'),
        self.getCacheKey(null, 'listStorageUnits'),
    ], true),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Boolean]),
    __metadata("design:returntype", Promise)
], CachedFileSystem.prototype, "deleteFile", null);
__decorate([
    (0, methodCache_1.cacheInvalidating)((self, sourceFilePath, destinationFilePath) => [
        self.getCacheKey(self.getParentDirectory(destinationFilePath), 'listFiles'),
        self.getCacheKey(destinationFilePath, 'readFile'),
        self.getCacheKey(destinationFilePath, 'getFile'),
        self.getCacheKey(destinationFilePath, 'exists'),
        self.getCacheKey(destinationFilePath, 'getFileChecksum'),
        self.getCacheKey(destinationFilePath, 'isDirectory'),
        self.getCacheKey(destinationFilePath, 'getArchiveInfo'),
        self.getCacheKey(self.getParentDirectory(sourceFilePath), 'listFiles'),
        self.getCacheKey(sourceFilePath, 'readFile'),
        self.getCacheKey(sourceFilePath, 'getFile'),
        self.getCacheKey(sourceFilePath, 'exists'),
        self.getCacheKey(sourceFilePath, 'getFileChecksum'),
        self.getCacheKey(sourceFilePath, 'isDirectory'),
        self.getCacheKey(sourceFilePath, 'getArchiveInfo'),
        self.getCacheKey(null, 'listStorageUnits'),
    ], true),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object, Object]),
    __metadata("design:returntype", Promise)
], CachedFileSystem.prototype, "moveFile", null);
__decorate([
    (0, methodCache_1.cacheInvalidating)((self, _sourceFilePath, destinationFilePath) => [
        self.getCacheKey(self.getParentDirectory(destinationFilePath), 'listFiles'),
        self.getCacheKey(destinationFilePath, 'readFile'),
        self.getCacheKey(destinationFilePath, 'getFile'),
        self.getCacheKey(destinationFilePath, 'exists'),
        self.getCacheKey(destinationFilePath, 'getFileChecksum'),
        self.getCacheKey(destinationFilePath, 'getArchiveInfo'),
        self.getCacheKey(destinationFilePath, 'isDirectory'),
        self.getCacheKey(null, 'listStorageUnits'),
    ], true),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], CachedFileSystem.prototype, "link", null);
__decorate([
    (0, methodCache_1.cachedOperation)((self, filePath) => self.getCacheKey(filePath, 'getFileChecksum')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, String]),
    __metadata("design:returntype", Promise)
], CachedFileSystem.prototype, "getFileChecksum", null);
__decorate([
    (0, methodCache_1.cacheInvalidating)((self, _archiveFilePath, destinationDirectoryPath) => [
        self.getCacheKey(self.getParentDirectory(destinationDirectoryPath), 'listFiles'),
        self.getCacheKey(destinationDirectoryPath, 'readFile'),
        self.getCacheKey(destinationDirectoryPath, 'getFile'),
        self.getCacheKey(destinationDirectoryPath, 'exists'),
        self.getCacheKey(destinationDirectoryPath, 'getFileChecksum'),
        self.getCacheKey(destinationDirectoryPath, 'getArchiveInfo'),
        self.getCacheKey(destinationDirectoryPath, 'isDirectory'),
        self.getCacheKey(null, 'listStorageUnits'),
    ], true),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object, String]),
    __metadata("design:returntype", Promise)
], CachedFileSystem.prototype, "extractFile", null);
__decorate([
    (0, methodCache_1.cacheInvalidating)((self, archiveFilePath) => [
        self.getCacheKey(self.getParentDirectory(archiveFilePath), 'listFiles'),
        self.getCacheKey(archiveFilePath, 'readFile'),
        self.getCacheKey(archiveFilePath, 'getFile'),
        self.getCacheKey(archiveFilePath, 'exists'),
        self.getCacheKey(archiveFilePath, 'getFileChecksum'),
        self.getCacheKey(archiveFilePath, 'getArchiveInfo'),
        self.getCacheKey(null, 'listStorageUnits'),
    ]),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Array]),
    __metadata("design:returntype", Promise)
], CachedFileSystem.prototype, "createArchive", null);
__decorate([
    (0, methodCache_1.cacheInvalidating)((self, directoryPath) => [
        self.getCacheKey(self.getParentDirectory(directoryPath), 'listFiles'),
        self.getCacheKey(directoryPath, 'readFile'),
        self.getCacheKey(directoryPath, 'getFile'),
        self.getCacheKey(directoryPath, 'exists'),
        self.getCacheKey(directoryPath, 'getFileChecksum'),
        self.getCacheKey(directoryPath, 'getArchiveInfo'),
        self.getCacheKey(directoryPath, 'isDirectory'),
    ], true),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], CachedFileSystem.prototype, "createDirectory", null);
__decorate([
    (0, methodCache_1.cachedOperation)((self, filePath) => self.getCacheKey(filePath, 'isDirectory')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], CachedFileSystem.prototype, "isDirectory", null);
__decorate([
    (0, methodCache_1.cachedOperation)((self) => self.getCacheKey(null, 'listStorageUnits')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], CachedFileSystem.prototype, "listStorageUnits", null);
__decorate([
    (0, methodCache_1.cachedOperation)((self, archiveFilePath) => self.getCacheKey(archiveFilePath, 'getArchiveInfo')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], CachedFileSystem.prototype, "getArchiveInfo", null);
__decorate([
    (0, methodCache_1.cacheInvalidating)((self) => [
        self.getCacheKey(null, 'listFiles'),
        self.getCacheKey(null, 'readFile'),
        self.getCacheKey(null, 'getFile'),
        self.getCacheKey(null, 'exists'),
        self.getCacheKey(null, 'getFileChecksum'),
        self.getCacheKey(null, 'isDirectory'),
        self.getCacheKey(null, 'listStorageUnits'),
        self.getCacheKey(null, 'getArchiveInfo'),
    ], true),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], CachedFileSystem.prototype, "wipeout", null);
//# sourceMappingURL=CachedFileSystem.js.map