declare enum Responsibility {
    /**
     * Deprovision the device.
     */
    DEPROVISIONING = 0,
    /**
     * Set and report time, time zone, and NTP server.
     */
    TIME = 1,
    /**
     * Set and report audio volume.
     */
    VOLUME = 2,
    /**
     * Control device power.
     */
    POWER = 3,
    /**
     * Set and report display brightness.
     */
    BRIGHTNESS = 4,
    /**
     * Set and report debugging status.
     */
    DEBUG = 5,
    /**
     * Kiosk mode typically disables IR Remote Control and prevents users from leaving the app.
     *
     * Control and report kiosk mode. Manage PIN.
     */
    KIOSK = 6,
    /**
     * Take and report screenshots.
     */
    SCREENSHOT = 7,
    /**
     * Install and report installed packages.
     */
    PACKAGES = 8,
    /**
     * Install firmware updates and report firmware version and type.
     */
    FIRMWARE = 9,
    /**
     * Manage servlets.
     */
    SERVLET = 10,
    /**
     * Set and report screen resolution and orientation.
     */
    SCREEN = 11,
    /**
     * Install app updates and report app version.
     */
    APP = 12,
    /**
     * Report bundled applet uid, version and config.
     */
    BUNDLED_APPLET = 13,
    /**
     * Set and report power timers.
     */
    TIMERS = 14,
    /**
     * Set and report power action schedule.
     */
    SCHEDULED_POWER = 15,
    /**
     * Report device temperature.
     */
    TEMPERATURE = 16,
    /**
     * Report battery status.
     */
    BATTERY = 17,
    /**
     * Report storage status.
     */
    STORAGE = 18,
    /**
     * Report device info.
     */
    DEVICE = 19,
    /**
     * Report network status.
     */
    NETWORK = 20,
    /**
     * Collect telemetrics.
     */
    TELEMETRY = 21,
    /**
     * Store device policies.
     */
    POLICY = 22,
    /**
     * Report proxy status.
     */
    PROXY = 23,
    /**
     * Report Wifi strength signal.
     */
    WIFI_STRENGTH = 24,
    /**
     * Platform specific mechanism to self recovery device.
     */
    AUTO_RECOVERY = 25,
    /**
     * Platform specific mechanism to recovery devices in LAN.
     */
    PEER_RECOVERY = 26,
    /**
     * Report supported capabilities for management status.
     */
    CAPABILITIES_MANAGEMENT = 27,
    /**
     * Report extended management url.
     */
    EXTENDED_MANAGEMENT = 28,
    /**
     * Report vpn.
     */
    VPN = 29,
    /**
     * Control Remote Desktop.
     */
    REMOTE_DESKTOP = 30,
    /**
     * Execute custom scripts.
     */
    CUSTOM_SCRIPTS = 31,
    /**
     * Report active core app modules and their status.
     * ex. Management (CC), Front (CA) etc.
     */
    APP_MODULES = 32,
    /**
     * Automatically control and report connected display with serial ports.
     */
    DISPLAY_MANAGER = 33,
    /**
     * Manage cryptographic keys and ability to encrypt/decrypt data.
     */
    SECRET_MANAGEMENT = 34
}
export default Responsibility;
