"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createNoResponsibilities = exports.createAllResponsibilities = exports.createAbsentResponsibilities = exports.createPresentResponsibilities = void 0;
/**
 * Create a responsibility policy having specified responsibilities.
 * @param responsibilities Present responsibilities.
 */
function createPresentResponsibilities(...responsibilities) {
    return {
        has: (responsibility) => {
            return responsibilities.includes(responsibility);
        },
    };
}
exports.createPresentResponsibilities = createPresentResponsibilities;
/**
 * Create a responsibility policy having *all other* than specified responsibilities.
 * @param responsibilities Absent responsibilities.
 */
function createAbsentResponsibilities(...responsibilities) {
    return {
        has: (responsibility) => {
            return !responsibilities.includes(responsibility);
        },
    };
}
exports.createAbsentResponsibilities = createAbsentResponsibilities;
/**
 * Create a responsibility policy having *all* responsibilities. This may be useful for testing.
 */
function createAllResponsibilities() {
    return {
        has: () => {
            return true;
        },
    };
}
exports.createAllResponsibilities = createAllResponsibilities;
/**
 * Create a responsibility policy having *no* responsibilities. This may be useful for testing.
 */
function createNoResponsibilities() {
    return {
        has: () => {
            return false;
        },
    };
}
exports.createNoResponsibilities = createNoResponsibilities;
//# sourceMappingURL=Responsibilities.js.map