interface BrowserEventEmitter<TSuccessEvent extends string, TFailedEvent extends string> {
    addEventListener(type: TSuccessEvent | TFailedEvent, listener: (...args: unknown[]) => unknown): void;
    removeEventListener(type: TSuccessEvent | TFailedEvent, listener: (...args: unknown[]) => unknown): void;
}
/**
 * The same logic as waitForSuccessOrFailEvents of @signageos/lib/dist/Events/eventsHelper.ts
 * however the interface of browser event emitter is different from nodejs event emitter
 */
export declare function waitForSuccessOrFailEvents<TSuccessEvent extends string, TFailedEvent extends string, TResult, TError>(eventEmitter: BrowserEventEmitter<TSuccessEvent, TFailedEvent>, successEvent: TSuccessEvent, failEvent: TFailedEvent): Promise<TResult>;
/**
 * The same logic as waitForSuccessEventsOrFailEvents of @signageos/lib/dist/Events/eventsHelper.ts
 * however the interface of browser event emitter is different from nodejs event emitter
 */
export declare function waitForSuccessEventsOrFailEvents<TSuccessEvent extends string, TFailedEvent extends string, TResult, TError = unknown>(eventEmitter: BrowserEventEmitter<TSuccessEvent, TFailedEvent>, successEvents: TSuccessEvent[], failEvents: TFailedEvent[]): Promise<TResult>;
export {};
