"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.deviceVerification = void 0;
const socketActionCreator_1 = require("../../Socket/socketActionCreator");
const authenticationActions_1 = require("@signageos/actions/dist/Authentication/authenticationActions");
const effects_1 = require("redux-saga/effects");
const deviceVerificationActions_1 = require("@signageos/actions/dist/Device/Verification/deviceVerificationActions");
function* deviceVerification(getNativeDriver) {
    yield (0, socketActionCreator_1.bindAndTakeEvery)(authenticationActions_1.AuthenticationSucceed, function* () {
        try {
            const deviceUid = yield getNativeDriver().getDeviceUid();
            yield (0, effects_1.put)({
                type: deviceVerificationActions_1.CheckVerification,
                uid: deviceUid,
            });
        }
        catch (error) {
            console.error('deviceVerification failed', error);
        }
    });
}
exports.deviceVerification = deviceVerification;
//# sourceMappingURL=deviceVerificationSagas.js.map