"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.setProprietaryTimer = exports.syncProprietaryTimerSaga = exports.setProprietaryTimerCallback = void 0;
const socketActionCreator_1 = require("../../Socket/socketActionCreator");
const effects_1 = require("redux-saga/effects");
const deviceTimerActions_1 = require("@signageos/actions/dist/Device/Timer/deviceTimerActions");
const TimerLevel_1 = require("@signageos/common-types/dist/Device/Timer/TimerLevel");
const responsible_1 = require("../../Feature/responsible");
const Responsibility_1 = __importDefault(require("../../Feature/Responsibility"));
const capable_1 = require("../../Feature/capable");
const FrontCapability_1 = require("@signageos/common-types/dist/Device/Capabilities/FrontCapability");
const dependencyInjection_1 = require("../../DI/dependencyInjection");
function* setProprietaryTimerCallback(timerStorage, action) {
    if (action.level === TimerLevel_1.TimerLevel.Proprietary) {
        try {
            yield (0, effects_1.call)(setProprietaryTimer, timerStorage, action);
            yield (0, effects_1.put)({
                type: deviceTimerActions_1.SetDeviceTimerSettingsSucceeded,
                uid: action.uid,
            });
        }
        catch (error) {
            console.error('syncProprietaryTimerSagas', error);
            yield (0, effects_1.put)({
                type: deviceTimerActions_1.SetDeviceTimerSettingsFailed,
                uid: action.uid,
            });
        }
    }
}
exports.setProprietaryTimerCallback = setProprietaryTimerCallback;
exports.syncProprietaryTimerSaga = (0, responsible_1.whenResponsible)(Responsibility_1.default.TIMERS, (0, capable_1.whenFrontCapable)(FrontCapability_1.FrontCapabilities.TIMERS_PROPRIETARY, (0, dependencyInjection_1.withDependencies)(['proprietaryTimerStorage'], function* ({ proprietaryTimerStorage }) {
    yield (0, socketActionCreator_1.takeEveryAndBindWhenPlatform)(deviceTimerActions_1.SetDeviceTimerSettings, setProprietaryTimerCallback, proprietaryTimerStorage);
})));
function setProprietaryTimer(timerStorage, action) {
    return __awaiter(this, void 0, void 0, function* () {
        if (action.timeOn === null && action.timeOff === null) {
            yield timerStorage.deleteShortTimer(action.timerType);
            return;
        }
        const { timerType: type, timeOn, timeOff, weekdays } = action;
        yield timerStorage.setShortTimer({
            type,
            timeOn,
            timeOff,
            weekdays,
        });
    });
}
exports.setProprietaryTimer = setProprietaryTimer;
//# sourceMappingURL=deviceProprietaryTimerSagas.js.map