"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.notifyCurrentTime = void 0;
const effects_1 = require("redux-saga/effects");
const deviceDateTimeActions_1 = require("@signageos/actions/dist/Device/DateTime/deviceDateTimeActions");
const dateTimeFacade_1 = require("../../Management/Device/DateTime/dateTimeFacade");
const dependencyInjection_1 = require("../../DI/dependencyInjection");
exports.notifyCurrentTime = (0, dependencyInjection_1.withDependencies)(['managementDriver', 'propertyStorage'], function* ({ managementDriver }) {
    try {
        const currentTimeWithTimezone = yield (0, effects_1.call)(dateTimeFacade_1.getCurrentTime, managementDriver);
        yield (0, effects_1.put)(Object.assign({ type: deviceDateTimeActions_1.NotifyCurrentTime }, currentTimeWithTimezone));
    }
    catch (error) {
        console.error('startupDeviceDateTimeSettings', error);
    }
});
//# sourceMappingURL=currentTimeSyncSagas.js.map