"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.deviceConnectSaga = void 0;
const deviceConnectActions_1 = require("@signageos/actions/dist/Device/Connect/deviceConnectActions");
const socketActionCreator_1 = require("../../Socket/socketActionCreator");
const dependencyInjection_1 = require("../../DI/dependencyInjection");
const deviceConnectActions_2 = require("./deviceConnectActions");
function* deviceConnectSaga() {
    yield (0, dependencyInjection_1.injectDependencies)({
        connectedBaseUrl: null,
    });
    yield (0, socketActionCreator_1.bindAndTakeEvery)(deviceConnectActions_1.ConnectDevice, function* (action) {
        yield (0, dependencyInjection_1.injectDependencies)({
            connectedBaseUrl: action.remoteIp,
        });
        yield (0, deviceConnectActions_2.putDeviceConnected)(action);
    });
    yield (0, socketActionCreator_1.bindAndTakeEvery)(deviceConnectActions_1.DisconnectDevice, function* () {
        yield (0, dependencyInjection_1.injectDependencies)({
            connectedBaseUrl: null,
        });
    });
}
exports.deviceConnectSaga = deviceConnectSaga;
//# sourceMappingURL=deviceConnectSagas.js.map