"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.areTelemetryIntervalsSame = exports.defaultTelemetryIntervals = exports.IntervalType = void 0;
var IntervalType;
(function (IntervalType) {
    IntervalType["SCREENSHOTS"] = "screenshots";
    IntervalType["TEMPERATURE"] = "temperature";
    IntervalType["APPLICATION_VERSION"] = "applicationVersion";
    IntervalType["BRIGHTNESS"] = "brightness";
    IntervalType["DATETIME"] = "datetime";
    IntervalType["DEBUG"] = "debug";
    IntervalType["FIRMWARE_VERSION"] = "firmwareVersion";
    IntervalType["ORIENTATION"] = "orientation";
    IntervalType["POWER_ACTIONS_SCHEDULE"] = "powerActionsSchedule";
    IntervalType["PROPRIETARY_TIMERS"] = "proprietaryTimers";
    IntervalType["REMOTE_CONTROL"] = "remoteControl";
    IntervalType["RESOLUTION"] = "resolution";
    IntervalType["TIMERS"] = "timers";
    IntervalType["VOLUME"] = "volume";
    IntervalType["STORAGE"] = "storage";
    IntervalType["BATTERY"] = "battery";
    IntervalType["BUNDLED_APPLET"] = "bundledApplet";
    IntervalType["POLICY"] = "policy";
    IntervalType["DEFAULT"] = "default";
    IntervalType["PROXY"] = "proxy";
    IntervalType["WIFI_STRENGTH"] = "wifiStrength";
    IntervalType["AUTO_RECOVERY"] = "autoRecovery";
    IntervalType["PEER_RECOVERY"] = "peerRecovery";
    IntervalType["MANAGEMENT_CAPABILITIES"] = "managementCapabilities";
    IntervalType["NETWORK_INTERFACES"] = "networkInterfaces";
    IntervalType["DISPLAY_POWER_ON"] = "displayPowerOn";
    IntervalType["APP_MODULES"] = "appModules";
    IntervalType["FEATURE_FLAGS"] = "featureFlags";
    IntervalType["CRYPTOGRAPHIC_KEY"] = "cryptographicKey";
    IntervalType["EXTENDED_MANAGEMENT_URL"] = "extendedManagementUrl";
})(IntervalType || (exports.IntervalType = IntervalType = {}));
exports.defaultTelemetryIntervals = {
    [IntervalType.SCREENSHOTS]: 6 * 60e3,
    [IntervalType.TEMPERATURE]: 5 * 60e3,
    [IntervalType.BRIGHTNESS]: 10 * 60e3,
    [IntervalType.DATETIME]: 10 * 60e3,
    [IntervalType.DEBUG]: 10 * 60e3,
    [IntervalType.ORIENTATION]: 10 * 60e3,
    [IntervalType.POWER_ACTIONS_SCHEDULE]: 10 * 60e3,
    [IntervalType.PROPRIETARY_TIMERS]: 10 * 60e3,
    [IntervalType.REMOTE_CONTROL]: 10 * 60e3,
    [IntervalType.RESOLUTION]: 10 * 60e3,
    [IntervalType.TIMERS]: 10 * 60e3,
    [IntervalType.VOLUME]: 10 * 60e3,
    [IntervalType.STORAGE]: 20 * 60e3,
    [IntervalType.BATTERY]: 20 * 60e3,
    [IntervalType.APPLICATION_VERSION]: 0,
    [IntervalType.FIRMWARE_VERSION]: 0,
    [IntervalType.BUNDLED_APPLET]: 0,
    [IntervalType.POLICY]: 1 * 60e3,
    [IntervalType.DEFAULT]: 10 * 60e3,
    [IntervalType.PROXY]: 10 * 60e3,
    [IntervalType.WIFI_STRENGTH]: 10 * 60e3,
    [IntervalType.AUTO_RECOVERY]: 10 * 60e3,
    [IntervalType.PEER_RECOVERY]: 10 * 60e3,
    [IntervalType.MANAGEMENT_CAPABILITIES]: 0,
    [IntervalType.NETWORK_INTERFACES]: 10 * 60e3,
    [IntervalType.DISPLAY_POWER_ON]: 10 * 60e3,
    [IntervalType.APP_MODULES]: 10 * 60e3,
    [IntervalType.FEATURE_FLAGS]: 10 * 60e3,
    [IntervalType.CRYPTOGRAPHIC_KEY]: 10 * 60e3,
    [IntervalType.EXTENDED_MANAGEMENT_URL]: 10 * 60e3,
};
function areTelemetryIntervalsSame(a, b) {
    return a === b || Object.values(IntervalType).every((it) => (a === null || a === void 0 ? void 0 : a[it]) === (b === null || b === void 0 ? void 0 : b[it]));
}
exports.areTelemetryIntervalsSame = areTelemetryIntervalsSame;
//# sourceMappingURL=telemetryIntervals.js.map