export type ITelemetryIntervals = {
    [intervalType in IntervalType]: number;
};
export declare enum IntervalType {
    SCREENSHOTS = "screenshots",
    TEMPERATURE = "temperature",
    APPLICATION_VERSION = "applicationVersion",
    BRIGHTNESS = "brightness",
    DATETIME = "datetime",
    DEBUG = "debug",
    FIRMWARE_VERSION = "firmwareVersion",
    ORIENTATION = "orientation",
    POWER_ACTIONS_SCHEDULE = "powerActionsSchedule",
    PROPRIETARY_TIMERS = "proprietaryTimers",
    REMOTE_CONTROL = "remoteControl",
    RESOLUTION = "resolution",
    TIMERS = "timers",
    VOLUME = "volume",
    STORAGE = "storage",
    BATTERY = "battery",
    BUNDLED_APPLET = "bundledApplet",
    POLICY = "policy",
    DEFAULT = "default",
    PROXY = "proxy",
    WIFI_STRENGTH = "wifiStrength",
    AUTO_RECOVERY = "autoRecovery",
    PEER_RECOVERY = "peerRecovery",
    MANAGEMENT_CAPABILITIES = "managementCapabilities",
    NETWORK_INTERFACES = "networkInterfaces",
    DISPLAY_POWER_ON = "displayPowerOn",
    APP_MODULES = "appModules",
    FEATURE_FLAGS = "featureFlags",
    CRYPTOGRAPHIC_KEY = "cryptographicKey",
    EXTENDED_MANAGEMENT_URL = "extendedManagementUrl"
}
export declare const defaultTelemetryIntervals: ITelemetryIntervals;
export declare function areTelemetryIntervalsSame(a: ITelemetryIntervals | undefined | null, b: ITelemetryIntervals | undefined | null): boolean;
