"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.updatingConfiguration = void 0;
const applicationActions_1 = require("@signageos/actions/dist/Application/applicationActions");
const socketActions_1 = require("@signageos/actions/dist/Socket/socketActions");
const wait_1 = __importDefault(require("@signageos/lib/dist/Timer/wait"));
const debug_1 = __importDefault(require("debug"));
const effects_1 = require("redux-saga/effects");
const dependencyInjection_1 = require("../../DI/dependencyInjection");
const debugConstants_1 = require("../../Debug/debugConstants");
const IConfig_1 = require("../../Display/IConfig");
const Property_1 = __importDefault(require("../../Property/Property"));
const deviceConfigurationActions_1 = require("./deviceConfigurationActions");
const deviceConfigurationCheckerSaga_1 = require("./deviceConfigurationCheckerSaga");
const deviceConfigurationHelper_1 = require("./deviceConfigurationHelper");
const telemetryIntervals_1 = require("./telemetryIntervals");
const debug = (0, debug_1.default)('@signageos/front-display:Device:Configuration:deviceConfigurationSagas');
function* updatingConfiguration(getNativeDriver, getManagementDriver, propertyStorage, defaultConfig, publicKey, threadName) {
    let lastConfig = {
        updatedAt: null,
        baseUrl: null,
        platformUri: null,
        socketDriver: null,
        staticBaseUrl: null,
        uploadBaseUrl: null,
        weinreUri: null,
        extendedManagementUrl: null,
        subscriptionType: null,
        checkInterval: null,
        telemetryIntervals: null,
        checkTimeBeforeConnection: false,
        offlineActionsLimits: null,
        featureFlags: null,
    };
    yield (0, effects_1.takeEvery)(applicationActions_1.StartApplication, function* () {
        yield initiateSubscriptionType(propertyStorage, lastConfig, defaultConfig.subscriptionType);
        const deviceUid = yield getNativeDriver().getDeviceUid();
        const configBaseUrl = yield (0, deviceConfigurationHelper_1.getConfigurationBaseUrl)(getNativeDriver(), defaultConfig);
        const overidenDefaultConfig = Object.assign(Object.assign({}, defaultConfig), { baseUrl: configBaseUrl });
        const isEnabled = yield getManagementDriver().isDebugEnabled();
        if (isEnabled) {
            // Debug checking is enabled after restart
            overidenDefaultConfig.checkInterval = debugConstants_1.DEBUG_CHECK_INTERVAL_MS;
        }
        yield* (0, deviceConfigurationCheckerSaga_1.checkDeviceConfigurationSaga)(deviceUid, overidenDefaultConfig, publicKey, undefined, threadName);
    });
    yield (0, effects_1.takeEvery)(deviceConfigurationActions_1.ConfigurationChanged, function* ({ config }) {
        debug(threadName, 'new configuration', config);
        if (config.baseUrl && config.baseUrl !== lastConfig.baseUrl) {
            yield (0, effects_1.put)({
                type: applicationActions_1.UpdateBaseUrl,
                baseUrl: config.baseUrl,
            });
        }
        if (config.staticBaseUrl && config.staticBaseUrl !== lastConfig.staticBaseUrl) {
            yield (0, dependencyInjection_1.injectDependencies)({
                staticBaseUrl: config.staticBaseUrl,
            });
        }
        if (config.uploadBaseUrl && config.uploadBaseUrl !== lastConfig.uploadBaseUrl) {
            yield (0, dependencyInjection_1.injectDependencies)({
                uploadBaseUrl: config.uploadBaseUrl,
            });
        }
        if (config.telemetryIntervals && !(0, telemetryIntervals_1.areTelemetryIntervalsSame)(config.telemetryIntervals, lastConfig.telemetryIntervals)) {
            yield (0, dependencyInjection_1.injectDependencies)({
                telemetryIntervals: config.telemetryIntervals,
            });
        }
        if (config.offlineActionsLimits && config.offlineActionsLimits !== lastConfig.offlineActionsLimits) {
            yield (0, dependencyInjection_1.injectDependencies)({
                offlineActionsLimits: config.offlineActionsLimits,
            });
        }
        if (config.weinreUri !== lastConfig.weinreUri) {
            yield propertyStorage.setValue(Property_1.default.DEBUG_WEINRE_SERVER_URL, config.weinreUri);
        }
        if (config.subscriptionType !== lastConfig.subscriptionType) {
            yield putSubscriptionType(config.subscriptionType || defaultConfig.subscriptionType);
            yield propertyStorage.setValue(Property_1.default.INITIAL_SUBSCRIPTION_TYPE, config.subscriptionType);
        }
        if (config.featureFlags && config.featureFlags !== lastConfig.featureFlags) {
            yield (0, dependencyInjection_1.injectDependencies)({
                featureFlags: config.featureFlags,
            });
        }
        if (config.platformUri !== lastConfig.platformUri ||
            config.socketDriver !== lastConfig.socketDriver ||
            config.updatedAt !== lastConfig.updatedAt ||
            config.subscriptionType !== lastConfig.subscriptionType ||
            config.checkTimeBeforeConnection !== lastConfig.checkTimeBeforeConnection) {
            yield (0, effects_1.put)({
                type: socketActions_1.PlatformConnect,
                platformUri: config.platformUri,
                driver: config.socketDriver,
                checkTimeBeforeConnection: config.checkTimeBeforeConnection,
            });
        }
        lastConfig = config;
    });
}
exports.updatingConfiguration = updatingConfiguration;
function* putSubscriptionType(subscriptionType) {
    yield (0, dependencyInjection_1.injectDependencies)({
        subscriptionType: subscriptionType,
    });
    switch (subscriptionType) {
        case IConfig_1.SubscriptionType.platform:
            yield (0, effects_1.put)({ type: deviceConfigurationActions_1.ChangeSubscriptionToPlatform });
            break;
        case IConfig_1.SubscriptionType.open:
        default:
            yield (0, effects_1.put)({ type: deviceConfigurationActions_1.ChangeSubscriptionToOpen });
    }
}
/** lastConfig is mutated in key subscriptionType */
function* initiateSubscriptionType(propertyStorage, lastConfig, defaultSubscriptionType) {
    const initialSubscriptionType = yield propertyStorage.getValueOrDefault(Property_1.default.INITIAL_SUBSCRIPTION_TYPE, null);
    // TODO Remove the artificial delay. Until then:
    // This MUST NOT emit subscription type before all `runPeriodicTaskSagaWhile*` calls get a chance to register callbacks.
    yield (0, wait_1.default)(500);
    yield putSubscriptionType(initialSubscriptionType || defaultSubscriptionType);
    lastConfig.subscriptionType = initialSubscriptionType;
}
//# sourceMappingURL=deviceConfigurationSagas.js.map