"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeChangeDetector = void 0;
const dateTimeFacade_1 = require("../Management/Device/DateTime/dateTimeFacade");
class TimeChangeDetector {
    constructor(managementDriver, checkingIntervalMs, significantThresholdMs) {
        this.managementDriver = managementDriver;
        this.checkingIntervalMs = checkingIntervalMs;
        this.significantThresholdMs = significantThresholdMs;
        this.createCheckTimeChange = (onChange) => () => __awaiter(this, void 0, void 0, function* () {
            const currentTime = yield (0, dateTimeFacade_1.getCurrentTime)(this.managementDriver);
            const expectedCurrentTime = Object.assign(Object.assign({}, this.lastTime), { timestamp: this.lastTime.timestamp + this.checkingIntervalMs });
            if (this.areTimesSignificantlyDifferent(currentTime, expectedCurrentTime)) {
                onChange();
            }
            this.lastTime = currentTime;
        });
    }
    start(onChange) {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.checkingHandler) {
                throw new Error(`It's running already`);
            }
            this.lastTime = yield (0, dateTimeFacade_1.getCurrentTime)(this.managementDriver);
            this.checkingHandler = setInterval(this.createCheckTimeChange(onChange), this.checkingIntervalMs);
        });
    }
    stop() {
        if (this.checkingHandler) {
            clearInterval(this.checkingHandler);
            this.checkingHandler = undefined;
        }
    }
    areTimesSignificantlyDifferent(time1, time2) {
        const changedByMs = Math.abs(time1.timestamp - time2.timestamp);
        return (changedByMs > this.significantThresholdMs ||
            time2.ntpEnabled !== time1.ntpEnabled ||
            time2.ntpServer !== time1.ntpServer ||
            time2.timezone !== time1.timezone ||
            time2.timezoneOffset !== time1.timezoneOffset);
    }
}
exports.TimeChangeDetector = TimeChangeDetector;
//# sourceMappingURL=timeChangeDetector.js.map