import { Saga, SagaIterator } from 'redux-saga';
import { Container, DynamicContainer } from './Container';
import { UpdateDIDependency } from './dependenciesActions';
/**
 * Use this function any time the dynamic dependencies are changed.
 */
export declare function injectDependencies(dependencies: Partial<DynamicContainer>): Generator<import("redux-saga/effects").PutEffect<UpdateDIDependency>, void, unknown>;
/**
 * withDependencies will not call the wrapped saga. If you'd like to process or yield saga you have to call it.
 * E.g.:
 *
 * ```ts
 * const mySaga = withDependencies(['dep1'], function* ({ dep1 }) {});
 * yield mySaga();
 * // or
 * yield call(mySaga);
 * ```
 *
 * The `();` at the end is necessary otherwise nothing is happening and saga is frozen.
 */
export declare const withDependencies: <D extends "applicationVersion" | "bundledApplet" | "featureFlags" | "powerActionTimer" | "telemetryInitialTimeoutMs" | "pingUrl" | "managementDriver" | "cacheDriver" | "responsibilities" | "propertyStorage" | "proprietaryTimerStorage" | "frontDriver" | "staticBaseUrl" | "connectedBaseUrl" | "uploadBaseUrl" | "subscriptionType" | "telemetryIntervals" | "offlineActionsLimits", Args extends unknown[]>(dependencyKeys: D[], saga: Saga<[Pick<Container, D>, ...Args]>) => Saga<Args>;
/**
 * If you want to get dependencies as soon as they will be available.
 */
export declare function awaitDependencies<D extends keyof Container>(dependencyKeys: D[]): SagaIterator;
