import { ITelemetryIntervals } from '../Device/Configuration/telemetryIntervals';
import { SubscriptionType } from '../Display/IConfig';
import { IResponsibilities } from '../Feature/Responsibilities';
import IFrontDriver from '../NativeDevice/Front/IFrontDriver';
import IManagementDriver, { IFrontManagementDriver } from '../NativeDevice/Management/IManagementDriver';
import { IPropertyStorage } from '../Property/propertyStorage';
import { IProprietaryTimerStorage } from '../Timer/ITimerStorage';
import { IBundledApplet } from '../Front/Applet/BundledApplet/bundledAppletActions';
import IPowerActionTimer from '../NativeDevice/Power/IPowerActionTimer';
import { ActionsLimit } from '@signageos/common-types/dist/Device/Actions/ActionLimit';
import ICacheDriver from '../NativeDevice/ICacheDriver';
import { DeviceFeatureFlagRecord } from '../Device/Configuration/featureFlags';
export interface DynamicContainer {
    staticBaseUrl: string;
    /**
     * Base URL of a machine connected directly to the device using SDK/CLI tools.
     * This URL is used for example for downloading applet binaries.
     */
    connectedBaseUrl: string | null;
    uploadBaseUrl: string;
    subscriptionType: SubscriptionType;
    telemetryIntervals: ITelemetryIntervals | null;
    offlineActionsLimits: ActionsLimit;
    featureFlags?: DeviceFeatureFlagRecord | null;
}
export interface SharedStaticContainer {
    responsibilities: IResponsibilities;
    propertyStorage: IPropertyStorage;
    proprietaryTimerStorage: IProprietaryTimerStorage;
    applicationVersion: string;
}
export interface ManagementStaticContainer extends SharedStaticContainer {
    bundledApplet: IBundledApplet | null;
    powerActionTimer: IPowerActionTimer;
    telemetryInitialTimeoutMs: number;
    pingUrl: string;
    managementDriver: IManagementDriver;
    cacheDriver: ICacheDriver;
}
export interface FrontStaticContainer extends SharedStaticContainer {
    frontDriver: IFrontDriver;
    managementDriver: IFrontManagementDriver;
}
export type StaticContainer = ManagementStaticContainer | FrontStaticContainer;
export type Container = ManagementStaticContainer & FrontStaticContainer & DynamicContainer;
