"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getConfiguration = void 0;
const getConfiguration = (config, encryptedFields, managementDriver) => __awaiter(void 0, void 0, void 0, function* () {
    let result = {};
    for (const key in config) {
        if (encryptedFields.includes(key)) {
            const jweGeneral = JSON.parse(Buffer.from(config[key], 'base64').toString('utf-8'));
            result[key] = yield managementDriver.secretManager.decryptJweGeneralToUtf8(jweGeneral);
        }
        else {
            result[key] = config[key];
        }
    }
    return result;
});
exports.getConfiguration = getConfiguration;
//# sourceMappingURL=utils.js.map