"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const deferred_1 = require("@signageos/lib/dist/Promise/deferred");
const wait_1 = __importDefault(require("@signageos/lib/dist/Timer/wait"));
const TIMEOUT_DELAY = 90e3;
/**
 * ProprietaryScriptsHelper contains static methods that are used to facilitate custom scripts execution functionality in browser
 * like create, append, and remove iframe elements.
 */
class BrowserRuntimeHelper {
    /**
     * Creates iframe element with absolute position placed at 0, 0 and dimensions set to 0, 0.
     * Page content defined by script string is put into srcdoc.
     * @param {string} script - page content specified as HTML string template
     * @returns {HTMLIFrameElement}
     */
    static createIframe(script) {
        const iframe = window.document.createElement('iframe');
        iframe.style.position = 'absolute';
        iframe.style.width = '0';
        iframe.style.height = '0';
        iframe.style.top = '0';
        iframe.style.left = '0';
        iframe.srcdoc = script;
        return iframe;
    }
    /**
     * Appends given iframe element to document's body.
     * @param {HTMLIFrameElement} iframe
     * @returns {void}
     */
    static appendIframe(iframe) {
        window.document.body.appendChild(iframe);
    }
    static injectPlatformSpecificAPIs(iframe, postResult, config, apis) {
        if (!iframe.contentWindow) {
            return;
        }
        Object.defineProperty(iframe.contentWindow, 'config', { value: config });
        Object.defineProperty(iframe.contentWindow, 'postResult', { value: postResult });
        if (apis) {
            for (const [key, value] of Object.entries(apis)) {
                Object.defineProperty(iframe.contentWindow, key, { value });
            }
        }
    }
    static addConfigToSos() {
        return `
			<script>
				Object.defineProperty(window.sos, 'config', { value: window.config });
			</script>
		`;
    }
    static createMessageHandler(iframeId, postResultID) {
        let result = {
            runtime: 'browser',
            stream: [{ pipeline: 'output', timestamp: Date.now(), data: 'OK - executed' }],
            exitCode: 0,
        };
        const waitUntilMessageReceived = (0, deferred_1.createDeferred)(true);
        const messageListener = (message) => {
            var _a, _b, _c, _d;
            if (((_b = (_a = message.data) === null || _a === void 0 ? void 0 : _a.iframeId) !== null && _b !== void 0 ? _b : '') === iframeId && ((_d = (_c = message.data) === null || _c === void 0 ? void 0 : _c.postResultID) !== null && _d !== void 0 ? _d : '') === postResultID) {
                result.stream[0].data = message.data.result;
                waitUntilMessageReceived.resolve();
            }
        };
        const getResult = () => __awaiter(this, void 0, void 0, function* () {
            yield Promise.race([(0, wait_1.default)(TIMEOUT_DELAY), waitUntilMessageReceived.promise]);
            return result;
        });
        return { messageListener, getResult };
    }
    static wrapScript(scriptUrl) {
        return `<script src="${scriptUrl}"></script>`;
    }
    static performCleanUp(messageListener, iframe) {
        window.document.body.removeChild(iframe);
        window.removeEventListener('message', messageListener);
    }
    static parseError(script, error) {
        return {
            runtime: script.runtime,
            stream: [{ pipeline: 'output', timestamp: Date.now(), data: error.message }],
            exitCode: 1,
        };
    }
    /**
     * Returns result of custom script execution.
     * At the time of writing, method always returns result with 'OK - executed'
     * even though there are no guarantees that the script executed successfully.
     * @param {CustomScript} script
     * @returns {CustomScriptResult}
     */
    static getResult(script) {
        return {
            runtime: script.runtime,
            stream: [{ pipeline: 'output', timestamp: Date.now(), data: 'OK - executed' }],
            exitCode: 0,
        };
    }
}
BrowserRuntimeHelper.checkIframeWindow = (iframe) => {
    // contentWindow is available after appending iframe.
    if (!iframe.contentWindow) {
        throw new Error('Execution failed: Cannot append iframe.');
    }
};
exports.default = BrowserRuntimeHelper;
//# sourceMappingURL=BrowserRuntimeHelper.js.map