"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomScriptDownloader = void 0;
class CustomScriptDownloader {
    constructor(offlineCache, getStaticBaseUrl) {
        this.offlineCache = offlineCache;
        this.getStaticBaseUrl = getStaticBaseUrl;
    }
    getOrDownloadCustomScript(archiveUri, mainFileName, md5Checksum) {
        return __awaiter(this, void 0, void 0, function* () {
            const customScriptLocalFolder = this.getCustomScriptDirectory(archiveUri, md5Checksum);
            const existsCustomScriptFile = yield this.offlineCache.fileExists(customScriptLocalFolder);
            if (!existsCustomScriptFile) {
                yield this.downloadCustomScriptToLocalStorage(archiveUri, customScriptLocalFolder, mainFileName);
            }
            return yield this.offlineCache.getFile(customScriptLocalFolder + '/' + mainFileName);
        });
    }
    downloadCustomScriptToLocalStorage(customScriptFilePath, localDirPath, mainFileName) {
        return __awaiter(this, void 0, void 0, function* () {
            const relativePath = this.removeStaticUrl(customScriptFilePath);
            yield this.ensureCustomScriptIsDownloaded(relativePath);
            yield this.ensureCustomScriptIsExtracted(relativePath, localDirPath);
            const mainFilePath = localDirPath + '/' + mainFileName;
            return yield this.offlineCache.getFile(mainFilePath);
        });
    }
    ensureCustomScriptIsDownloaded(customScriptFileName) {
        return __awaiter(this, void 0, void 0, function* () {
            const existsCustomScriptFolder = yield this.offlineCache.fileExists(customScriptFileName);
            if (!existsCustomScriptFolder) {
                const staticBaseUrl = this.getStaticBaseUrl();
                const customScriptUri = staticBaseUrl + '/custom-script/' + customScriptFileName;
                yield this.offlineCache.retriableDownloadFile(5, customScriptFileName, customScriptUri, undefined, true);
            }
        });
    }
    ensureCustomScriptIsExtracted(customScriptFilePath, customScriptDirectoryPath) {
        return __awaiter(this, void 0, void 0, function* () {
            const existsCustomScript = yield this.offlineCache.fileExists(customScriptDirectoryPath);
            const customScriptFile = yield this.offlineCache.getFile(customScriptFilePath);
            if (!existsCustomScript && customScriptFile) {
                yield this.offlineCache.extractFile(customScriptFilePath, customScriptDirectoryPath, 'zip', true);
            }
        });
    }
    getCustomScriptDirectory(archiveUri, md5Checksum) {
        const relativePath = this.removeStaticUrl(archiveUri);
        return relativePath.substring(0, relativePath.lastIndexOf('/')) + '/' + md5Checksum;
    }
    removeStaticUrl(archiveUri) {
        const matches = archiveUri.match(/custom-script\/(.+)$/);
        return matches ? matches[1] : archiveUri;
    }
}
exports.CustomScriptDownloader = CustomScriptDownloader;
//# sourceMappingURL=CustomScriptDownloader.js.map